/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.test.rules;

import com.atlassian.test.rules.Flaky;
import java.lang.annotation.Annotation;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class IgnoreFlakes
implements TestRule {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd");

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Optional annotation = IgnoreFlakes.this.getAnnotation(description);
                if (IgnoreFlakes.this.shouldRunTest(annotation)) {
                    base.evaluate();
                } else if (IgnoreFlakes.this.testIsExpired(annotation)) {
                    Assert.fail((String)"Flaky test has expired. Delete or fix.");
                }
                Assume.assumeTrue((String)"Ignoring Flaky test.", (boolean)false);
            }
        };
    }

    private boolean shouldRunTest(Optional<Flaky> optionalAnnotation) {
        boolean flakey_test = optionalAnnotation.isPresent();
        boolean flakey_run = System.getProperty("run.flaky.on") != null;
        return flakey_test == flakey_run;
    }

    private Optional<Flaky> getAnnotation(Description description) {
        try {
            Optional<Annotation> annotation = Optional.ofNullable(description.getAnnotation(Flaky.class));
            if (!annotation.isPresent()) {
                annotation = Optional.ofNullable(description.getTestClass().getAnnotation(Flaky.class));
            }
            return annotation;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean testIsExpired(Optional<Flaky> optionalAnnotation) {
        Calendar cal = Calendar.getInstance();
        return optionalAnnotation.map(a -> {
            try {
                return cal.getTime().after(sdf.parse(a.expiryDate()));
            }
            catch (Exception e) {
                return false;
            }
        }).orElse(false);
    }
}

