package com.atlassian.diagnostics.internal.platform.monitor.gc;

import com.google.common.collect.EvictingQueue;

import java.time.Instant;
import java.util.Optional;
import java.util.Queue;

public class GCReadsStore {
    private final Queue<GCRead> gcReads;

    public GCReadsStore(int maxQueueSize) {
        gcReads = EvictingQueue.create(maxQueueSize);
    }

    public void storeRead(final GCRead gcRead) {
        gcReads.add(gcRead);
    }

    public Optional<GCRead> getReadIfHappenedBefore(final Instant timestamp) {
        final GCRead read = gcReads.peek();
        if (read != null && readHappenedBefore(read, timestamp)) {
            gcReads.remove();
            return Optional.of(read);
        }
        return Optional.empty();
    }

    private boolean readHappenedBefore(final GCRead read, final Instant timestamp) {
        return timestamp.compareTo(read.getTimestamp()) >= 0;
    }
}
