package com.atlassian.diagnostics.internal.platform.monitor.gc;

import java.time.Duration;
import java.time.Instant;
import java.util.Objects;

import static java.util.Objects.requireNonNull;

public class GCRead {
    private final long collectionCount;
    private final Duration collectionTime;
    private final Instant timestamp;

    private GCRead(long collectionCount, Duration collectionTime, Instant timestamp) {
        this.collectionCount = collectionCount;
        this.collectionTime = collectionTime;
        this.timestamp = timestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getCollectionCount() {
        return collectionCount;
    }

    public Duration getCollectionTime() {
        return collectionTime;
    }

    public Instant getTimestamp() {
        return timestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        GCRead gcRead = (GCRead) o;
        return collectionCount == gcRead.collectionCount && collectionTime.equals(gcRead.collectionTime) && timestamp.equals(gcRead.timestamp);
    }

    @Override
    public int hashCode() {
        return Objects.hash(collectionCount, collectionTime, timestamp);
    }

    @Override
    public String toString() {
        return "GCRead{" +
                "collectionCount=" + collectionCount +
                ", collectionTime=" + collectionTime +
                ", timestamp=" + timestamp +
                '}';
    }

    public static final class Builder {
        private Long collectionCount;
        private Duration collectionTime;
        private Instant timestamp;

        private Builder() {
        }

        public Builder collectionCount(long collectionCount) {
            this.collectionCount = collectionCount;
            return this;
        }

        public Builder collectionTime(Duration collectionTime) {
            this.collectionTime = collectionTime;
            return this;
        }

        public Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public GCRead build() {
            return new GCRead(
                    requireNonNull(collectionCount),
                    requireNonNull(collectionTime),
                    requireNonNull(timestamp));
        }
    }
}
