package com.atlassian.diagnostics.internal.platform.analytics.directory;

import com.atlassian.diagnostics.internal.platform.monitor.operatingsystem.directory.DirectoryType;

import javax.annotation.Nonnull;

public class LowDirectoryDiskSpaceAnalyticsEvent {

    private final Long freeDiskSpaceInMb;
    private final String folderType;
    private final Long totalDiskSizeInMb;
    private final Long minDiskSizeThresholdInMb;

    protected LowDirectoryDiskSpaceAnalyticsEvent(@Nonnull final DirectoryType folderType,
                                                  @Nonnull final Long freeDiskSpaceInMb,
                                                  @Nonnull final Long totalDiskSizeInMb,
                                                  @Nonnull final Long minDiskSizeThresholdInMb) {
        this.folderType = folderType.name;
        this.totalDiskSizeInMb = totalDiskSizeInMb;
        this.freeDiskSpaceInMb = freeDiskSpaceInMb;
        this.minDiskSizeThresholdInMb = minDiskSizeThresholdInMb;
    }

    public String getFolderType() {
        return folderType;
    }

    public Long getTotalDiskSizeInMb() {
        return totalDiskSizeInMb;
    }

    public Long getFreeDiskSpaceInMb() {
        return freeDiskSpaceInMb;
    }

    public Long getMinDiskSizeThresholdInMb() {
        return minDiskSizeThresholdInMb;
    }
}
