package com.atlassian.diagnostics.internal.ipd.metrics;

import com.atlassian.diagnostics.ipd.api.meters.CounterMeter;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterConfig;
import com.atlassian.diagnostics.ipd.api.meters.config.MeterFactory;
import com.atlassian.util.profiling.Metrics;
import com.google.common.collect.ImmutableList;

import java.util.List;

/**
 * Metric for counter value. Value of this metric should always increase.
 * @since 3.0.0
 */

public class CounterMeterImpl extends IpdProfilingMeter implements CounterMeter {
    private static final String TYPE_ID = "counter";

    public static final List<String> ATTRIBUTES = ImmutableList.of("Count");
    private final Metrics.Builder micrometerMetric;

    protected CounterMeterImpl(final MeterConfig config) {
        super(config, ATTRIBUTES, ATTRIBUTES);
        micrometerMetric = Metrics.metric(profilingKey.getMetricName()).tags(profilingKey.getTags());
    }

    public void increment(long value) {
        if (isEnabled()) {
            micrometerMetric.incrementCounter(value);
            metricUpdated();
        }
    }

    @Override
    public String getTypeId() {
        return TYPE_ID;
    }

    public static MeterFactory<CounterMeter> factory() {
        return staticFactory;
    }

    private static final MeterFactory<CounterMeter> staticFactory = new MeterFactory<>(CounterMeterImpl::new, TYPE_ID, "counter");
}

