package com.atlassian.diagnostics.internal.ipd;

import com.atlassian.diagnostics.ipd.api.MeterKey;
import com.atlassian.diagnostics.ipd.api.MeterTag;
import com.atlassian.util.profiling.MetricKey;
import com.atlassian.util.profiling.MetricTag;
import com.atlassian.util.profiling.micrometer.util.QualifiedCompatibleHierarchicalNameMapper;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import java.util.Arrays;

import static io.micrometer.core.instrument.Meter.Type.OTHER;
import static io.micrometer.core.instrument.config.NamingConvention.dot;
import static java.util.stream.Collectors.toList;

/**
 * @since 5.0.0
 */
public final class IpdUtils {

    public static final HierarchicalNameMapper DEFAULT_NAME_MAPPER = new QualifiedCompatibleHierarchicalNameMapper();

    private IpdUtils() {
    }

    public static MetricKey getProfilingKey(final MeterKey meterKey) {
        return MetricKey.metricKey(meterKey.getName(), getProfilingTags(meterKey.getTags()));
    }

    public static MetricTag.RequiredMetricTag[] getProfilingTags(final MeterTag[] meterTags) {
        return Arrays.stream(meterTags).map(IpdUtils::getProfilingTag).toArray(MetricTag.RequiredMetricTag[]::new);
    }

    public static MetricTag getProfilingTag(final MeterTag meterTag) {
        return MetricTag.of(meterTag.getKey(), meterTag.getValue());
    }

    public static ObjectName constructObjectName(String productPrefix, MeterKey meterKey) {
        final Meter.Id dummyMeterId = new Meter.Id(meterKey.getName(), getMicrometerTags(meterKey.getTags()), null, null, OTHER);
        final String objectName = productPrefix + ":" + DEFAULT_NAME_MAPPER.toHierarchicalName(dummyMeterId, dot);
        try {
            return new ObjectName(objectName);
        } catch(MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static Tags getMicrometerTags(final MeterTag[] tags) {
        return Tags.of(Arrays.stream(tags).map(t -> Tag.of(t.getKey(), t.getValue())).collect(toList()));
    }

}
