package com.atlassian.diagnostics.internal.ipd;


import com.atlassian.diagnostics.ipd.api.IpdLoggingService;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;

import java.time.Instant;

public class IpdRegistryLogger {

    private final IpdRegistry ipdRegistry;
    private final IpdLoggingService ipdLoggingService;

    public IpdRegistryLogger(final IpdRegistry ipdRegistry, final IpdLoggingService ipdLoggingService) {
        this.ipdRegistry = ipdRegistry;
        this.ipdLoggingService = ipdLoggingService;
    }

    public void logRegisteredMetrics() {
        Instant timestamp = Instant.now();
        ipdRegistry.getMeters().stream()
                .filter(metric -> metric.getConfig().isIntervalLoggingEnabled())
                .forEach(metric -> ipdLoggingService.logMetric(metric, timestamp));
    }
}
