/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devrel.servlet;

import com.atlassian.devrel.plugin.SoapService;
import com.atlassian.devrel.provider.SoapServiceProvider;
import com.atlassian.devrel.rest.model.RestDescriptor;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestBrowserServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(RestBrowserServlet.class);
    private static final String BROWSER_TEMPLATE = "/templates/browser.vm";
    private final PluginAccessor pluginAccessor;
    private final TemplateRenderer renderer;
    private final SoapServiceProvider soapServiceProvider;

    public RestBrowserServlet(PluginAccessor pluginAccessor, TemplateRenderer renderer, SoapServiceProvider soapServiceProvider) {
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor, (Object)"pluginAccessor");
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
        this.soapServiceProvider = (SoapServiceProvider)Preconditions.checkNotNull((Object)soapServiceProvider, (Object)"soapServiceProvider");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap context = Maps.newHashMap();
        context.put("restDescriptors", this.getRestDescriptors());
        context.put("jsonRpcDescriptors", this.getJsonRpcDescriptors());
        resp.setContentType("text/html;charset=utf-8");
        this.renderer.render(BROWSER_TEMPLATE, (Map)context, (Writer)resp.getWriter());
    }

    private List<RestDescriptor> getJsonRpcDescriptors() {
        ArrayList jsonRpcDescriptors = Lists.newArrayList();
        Iterable<? extends SoapService> soaps = this.soapServiceProvider.getSoapServices();
        for (SoapService soapService : soaps) {
            RestDescriptor.Builder builder = new RestDescriptor.Builder();
            Plugin plugin = soapService.getPlugin();
            builder.pluginKey(plugin.getKey()).pluginCompleteKey(soapService.getCompleteKey()).pluginName(plugin.getName()).pluginDescription(soapService.getDescription()).basePath("/rpc/json-rpc").version(soapService.getServicePath());
            jsonRpcDescriptors.add(builder.build());
        }
        return jsonRpcDescriptors;
    }

    private List<RestDescriptor> getRestDescriptors() {
        Collection restServlets = this.pluginAccessor.getModuleDescriptors(new ModuleDescriptorOfClassNamePredicate("com.atlassian.plugins.rest.module.RestServletFilterModuleDescriptor"));
        ArrayList<RestDescriptor> restDescriptors = new ArrayList<RestDescriptor>(restServlets.size());
        for (ModuleDescriptor servlet : restServlets) {
            String version;
            String basePath;
            Class[] params = new Class[]{};
            Object[] args = new Object[]{};
            try {
                Method getBasePath = servlet.getClass().getMethod("getBasePath", params);
                basePath = (String)getBasePath.invoke((Object)servlet, args);
                Method getVersion = servlet.getClass().getMethod("getVersion", params);
                Object apiVersion = getVersion.invoke((Object)servlet, args);
                version = apiVersion.toString();
            }
            catch (Exception e) {
                continue;
            }
            Plugin plugin = servlet.getPlugin();
            RestDescriptor.Builder builder = new RestDescriptor.Builder().basePath(basePath).version(version).pluginCompleteKey(servlet.getCompleteKey()).pluginKey(plugin.getKey()).pluginName(plugin.getName()).pluginDescription(servlet.getDescription());
            restDescriptors.add(builder.build());
        }
        return restDescriptors;
    }

    public class ModuleDescriptorOfClassNamePredicate<T>
    implements ModuleDescriptorPredicate<T> {
        private final String moduleDescriptorClass;

        public ModuleDescriptorOfClassNamePredicate(String targetClass) {
            this.moduleDescriptorClass = targetClass;
        }

        public boolean matches(ModuleDescriptor<? extends T> moduleDescriptor) {
            return moduleDescriptor != null && moduleDescriptor.getClass().getName().equals(this.moduleDescriptorClass);
        }
    }
}

