/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas.jackson;

import com.atlassian.devops.schemas.Envelope;
import com.atlassian.devops.schemas.ImmutableEnvelope;
import com.atlassian.devops.schemas.Payloadable;
import com.atlassian.devops.schemas.SchemaConstants;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;

public class EnvelopeDeserializer
extends JsonDeserializer<Envelope> {
    public Envelope deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode envelopeNode = (JsonNode)parser.readValueAs(JsonNode.class);
        String type = EnvelopeDeserializer.getAsText(envelopeNode, "type");
        String schemaAri = EnvelopeDeserializer.getAsText(envelopeNode, "schemaAri");
        Payloadable payloadable = EnvelopeDeserializer.getPayloadable(parser, envelopeNode, type);
        return ImmutableEnvelope.builder().type(type).schemaAri(schemaAri).payload(payloadable).build();
    }

    private static String getAsText(JsonNode envelopeNode, String nodeName) throws IOException {
        return Optional.ofNullable(envelopeNode.findValue(nodeName)).map(JsonNode::asText).orElseThrow(EnvelopeDeserializer.fieldRequired(nodeName));
    }

    private static JsonNode getAsNode(JsonNode node, String nodeName) throws IOException {
        return Optional.ofNullable(node.get(nodeName)).orElseThrow(EnvelopeDeserializer.fieldRequired(nodeName));
    }

    private static Payloadable getPayloadable(JsonParser parser, JsonNode envelopeNode, String type) throws IOException {
        Class<? extends Payloadable> typeClass = SchemaConstants.MAPPINGS.get(type);
        if (typeClass == null) {
            throw new IOException("No mapper for " + type);
        }
        JsonNode payloadNode = EnvelopeDeserializer.getAsNode(envelopeNode, "payload");
        return EnvelopeDeserializer.buildObject(parser, payloadNode, typeClass);
    }

    private static <T extends Payloadable> Payloadable buildObject(JsonParser parser, JsonNode node, Class<T> clazz) throws JsonProcessingException {
        return (Payloadable)parser.getCodec().treeToValue((TreeNode)node, clazz);
    }

    private static Supplier<IOException> fieldRequired(String nodeName) {
        return () -> new IOException("Cannot deserialize Envelope, required field: " + nodeName + " is null");
    }
}

