/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas;

import com.atlassian.devops.schemas.Envelope;
import com.atlassian.devops.schemas.Payloadable;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Envelope", generator="Immutables")
@Immutable
public final class ImmutableEnvelope
implements Envelope {
    private final String type;
    private final String schemaAri;
    private final Payloadable payload;

    private ImmutableEnvelope(String type, String schemaAri, Payloadable payload) {
        this.type = type;
        this.schemaAri = schemaAri;
        this.payload = payload;
    }

    @Override
    @JsonProperty
    public String type() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String schemaAri() {
        return this.schemaAri;
    }

    @Override
    @JsonProperty
    public Payloadable payload() {
        return this.payload;
    }

    public final ImmutableEnvelope withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ImmutableEnvelope(newValue, this.schemaAri, this.payload);
    }

    public final ImmutableEnvelope withSchemaAri(String value) {
        String newValue = Objects.requireNonNull(value, "schemaAri");
        if (this.schemaAri.equals(newValue)) {
            return this;
        }
        return new ImmutableEnvelope(this.type, newValue, this.payload);
    }

    public final ImmutableEnvelope withPayload(Payloadable value) {
        if (this.payload == value) {
            return this;
        }
        Payloadable newValue = Objects.requireNonNull(value, "payload");
        return new ImmutableEnvelope(this.type, this.schemaAri, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEnvelope && this.equalTo((ImmutableEnvelope)another);
    }

    private boolean equalTo(ImmutableEnvelope another) {
        return this.type.equals(another.type) && this.schemaAri.equals(another.schemaAri) && this.payload.equals(another.payload);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.schemaAri.hashCode();
        h += (h << 5) + this.payload.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Envelope").omitNullValues().add("type", (Object)this.type).add("schemaAri", (Object)this.schemaAri).add("payload", (Object)this.payload).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEnvelope fromJson(Json json) {
        Builder builder = (Builder)ImmutableEnvelope.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.schemaAri != null) {
            builder.schemaAri(json.schemaAri);
        }
        if (json.payload != null) {
            builder.payload(json.payload);
        }
        return builder.build();
    }

    public static ImmutableEnvelope copyOf(Envelope instance) {
        if (instance instanceof ImmutableEnvelope) {
            return (ImmutableEnvelope)instance;
        }
        return ((Builder)ImmutableEnvelope.builder()).type(instance.type()).schemaAri(instance.schemaAri()).payload(instance.payload()).build();
    }

    public static TypeBuildStage builder() {
        return new Builder();
    }

    @Generated(from="Envelope", generator="Immutables")
    public static interface BuildFinal {
        public ImmutableEnvelope build();
    }

    @Generated(from="Envelope", generator="Immutables")
    public static interface PayloadBuildStage {
        public BuildFinal payload(Payloadable var1);
    }

    @Generated(from="Envelope", generator="Immutables")
    public static interface SchemaAriBuildStage {
        public PayloadBuildStage schemaAri(String var1);
    }

    @Generated(from="Envelope", generator="Immutables")
    public static interface TypeBuildStage {
        public SchemaAriBuildStage type(String var1);
    }

    @Generated(from="Envelope", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements TypeBuildStage,
    SchemaAriBuildStage,
    PayloadBuildStage,
    BuildFinal {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_SCHEMA_ARI = 2L;
        private static final long INIT_BIT_PAYLOAD = 4L;
        private long initBits = 7L;
        @Nullable
        private String type;
        @Nullable
        private String schemaAri;
        @Nullable
        private Payloadable payload;

        private Builder() {
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder type(String type) {
            Builder.checkNotIsSet(this.typeIsSet(), "type");
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder schemaAri(String schemaAri) {
            Builder.checkNotIsSet(this.schemaAriIsSet(), "schemaAri");
            this.schemaAri = Objects.requireNonNull(schemaAri, "schemaAri");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @JsonProperty
        @CanIgnoreReturnValue
        public final Builder payload(Payloadable payload) {
            Builder.checkNotIsSet(this.payloadIsSet(), "payload");
            this.payload = Objects.requireNonNull(payload, "payload");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        public ImmutableEnvelope build() {
            this.checkRequiredAttributes();
            return new ImmutableEnvelope(this.type, this.schemaAri, this.payload);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean schemaAriIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean payloadIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of Envelope is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.schemaAriIsSet()) {
                attributes.add("schemaAri");
            }
            if (!this.payloadIsSet()) {
                attributes.add("payload");
            }
            return "Cannot build Envelope, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Envelope", generator="Immutables")
    static final class Json
    implements Envelope {
        @Nullable
        String type;
        @Nullable
        String schemaAri;
        @Nullable
        Payloadable payload;

        Json() {
        }

        @JsonProperty
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty
        public void setSchemaAri(String schemaAri) {
            this.schemaAri = schemaAri;
        }

        @JsonProperty
        public void setPayload(Payloadable payload) {
            this.payload = payload;
        }

        @Override
        public String type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String schemaAri() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Payloadable payload() {
            throw new UnsupportedOperationException();
        }
    }
}

