/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.devops.schemas;

import com.atlassian.devops.schemas.Association;
import com.atlassian.devops.schemas.EntityAssociation;
import com.atlassian.devops.schemas.jackson.AssociationDeserializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="EntityAssociation", generator="Immutables")
@Immutable
public final class ImmutableEntityAssociation
implements EntityAssociation {
    private final List<Association> current;
    private final List<Association> removed;

    private ImmutableEntityAssociation(List<Association> current, List<Association> removed) {
        this.current = current;
        this.removed = removed;
    }

    @Override
    @JsonProperty
    @JsonDeserialize(contentUsing=AssociationDeserializer.class)
    public List<Association> current() {
        return this.current;
    }

    @Override
    @JsonProperty
    @JsonDeserialize(contentUsing=AssociationDeserializer.class)
    public List<Association> removed() {
        return this.removed;
    }

    public final ImmutableEntityAssociation withCurrent(Association ... elements) {
        List<Association> newValue = ImmutableEntityAssociation.createUnmodifiableList(false, ImmutableEntityAssociation.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEntityAssociation(newValue, this.removed);
    }

    public final ImmutableEntityAssociation withCurrent(Iterable<? extends Association> elements) {
        if (this.current == elements) {
            return this;
        }
        List<Association> newValue = ImmutableEntityAssociation.createUnmodifiableList(false, ImmutableEntityAssociation.createSafeList(elements, true, false));
        return new ImmutableEntityAssociation(newValue, this.removed);
    }

    public final ImmutableEntityAssociation withRemoved(Association ... elements) {
        List<Association> newValue = ImmutableEntityAssociation.createUnmodifiableList(false, ImmutableEntityAssociation.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableEntityAssociation(this.current, newValue);
    }

    public final ImmutableEntityAssociation withRemoved(Iterable<? extends Association> elements) {
        if (this.removed == elements) {
            return this;
        }
        List<Association> newValue = ImmutableEntityAssociation.createUnmodifiableList(false, ImmutableEntityAssociation.createSafeList(elements, true, false));
        return new ImmutableEntityAssociation(this.current, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntityAssociation && this.equalTo((ImmutableEntityAssociation)another);
    }

    private boolean equalTo(ImmutableEntityAssociation another) {
        return this.current.equals(another.current) && this.removed.equals(another.removed);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.current.hashCode();
        h += (h << 5) + this.removed.hashCode();
        return h;
    }

    public String toString() {
        return "EntityAssociation{current=" + this.current + ", removed=" + this.removed + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEntityAssociation fromJson(Json json) {
        Builder builder = ImmutableEntityAssociation.builder();
        if (json.current != null) {
            builder.addAllCurrent(json.current);
        }
        if (json.removed != null) {
            builder.addAllRemoved(json.removed);
        }
        return builder.build();
    }

    public static ImmutableEntityAssociation copyOf(EntityAssociation instance) {
        if (instance instanceof ImmutableEntityAssociation) {
            return (ImmutableEntityAssociation)instance;
        }
        return ImmutableEntityAssociation.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="EntityAssociation", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<Association> current = new ArrayList<Association>();
        private List<Association> removed = new ArrayList<Association>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(EntityAssociation instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllCurrent(instance.current());
            this.addAllRemoved(instance.removed());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCurrent(Association element) {
            this.current.add(Objects.requireNonNull(element, "current element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCurrent(Association ... elements) {
            for (Association element : elements) {
                this.current.add(Objects.requireNonNull(element, "current element"));
            }
            return this;
        }

        @JsonProperty
        @JsonDeserialize(contentUsing=AssociationDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder current(Iterable<? extends Association> elements) {
            this.current.clear();
            return this.addAllCurrent(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCurrent(Iterable<? extends Association> elements) {
            for (Association association : elements) {
                this.current.add(Objects.requireNonNull(association, "current element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRemoved(Association element) {
            this.removed.add(Objects.requireNonNull(element, "removed element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRemoved(Association ... elements) {
            for (Association element : elements) {
                this.removed.add(Objects.requireNonNull(element, "removed element"));
            }
            return this;
        }

        @JsonProperty
        @JsonDeserialize(contentUsing=AssociationDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder removed(Iterable<? extends Association> elements) {
            this.removed.clear();
            return this.addAllRemoved(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRemoved(Iterable<? extends Association> elements) {
            for (Association association : elements) {
                this.removed.add(Objects.requireNonNull(association, "removed element"));
            }
            return this;
        }

        public ImmutableEntityAssociation build() {
            return new ImmutableEntityAssociation(ImmutableEntityAssociation.createUnmodifiableList(true, this.current), ImmutableEntityAssociation.createUnmodifiableList(true, this.removed));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="EntityAssociation", generator="Immutables")
    static final class Json
    implements EntityAssociation {
        @Nullable
        List<Association> current = Collections.emptyList();
        @Nullable
        List<Association> removed = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        @JsonDeserialize(contentUsing=AssociationDeserializer.class)
        public void setCurrent(List<Association> current) {
            this.current = current;
        }

        @JsonProperty
        @JsonDeserialize(contentUsing=AssociationDeserializer.class)
        public void setRemoved(List<Association> removed) {
            this.removed = removed;
        }

        @Override
        public List<Association> current() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Association> removed() {
            throw new UnsupportedOperationException();
        }
    }
}

