/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.rest;

import com.atlassian.crowd.embedded.admin.DirectoryMapper;
import com.atlassian.crowd.embedded.admin.crowd.CrowdDirectoryConfiguration;
import com.atlassian.crowd.embedded.admin.dto.CrowdUserSyncPreviewRequest;
import com.atlassian.crowd.embedded.admin.dto.LdapUserSyncPreviewRequest;
import com.atlassian.crowd.embedded.admin.dto.UserSyncPreviewResult;
import com.atlassian.crowd.embedded.admin.ldap.LdapDirectoryConfiguration;
import com.atlassian.crowd.embedded.admin.service.UserSyncPreviewService;
import com.atlassian.crowd.embedded.admin.util.PasswordRestoreUtil;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="/preview-users")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class UserPreviewResource {
    @Autowired
    private UserSyncPreviewService userSyncPreviewService;
    @Autowired
    private DirectoryMapper directoryMapper;
    @Autowired
    private UserManager userManager;
    @Autowired
    private PasswordRestoreUtil passwordRestoreUtil;
    private ObjectMapper objectMapper = new ObjectMapper();

    @POST
    @Path(value="/ldap")
    public Response getLdapUserPreviewResult(InputStream requestBody) throws Exception {
        this.checkSysAdmin();
        LdapUserSyncPreviewRequest request = (LdapUserSyncPreviewRequest)this.objectMapper.readValue(requestBody, LdapUserSyncPreviewRequest.class);
        LdapDirectoryConfiguration configuration = request.getDirectoryConfiguration();
        Directory directory = this.directoryMapper.buildLdapDirectory(configuration);
        Directory directoryWithPassword = this.passwordRestoreUtil.restoreOldPasswordIfNewIsEmpty(configuration, directory);
        UserSyncPreviewResult userPreviewResult = this.userSyncPreviewService.getUserPreviewResult(directoryWithPassword, request);
        return Response.ok((Object)userPreviewResult).build();
    }

    @POST
    @Path(value="/crowd")
    public Response getCrowdUserPreviewResult(InputStream requestBody) throws Exception {
        this.checkSysAdmin();
        CrowdUserSyncPreviewRequest request = (CrowdUserSyncPreviewRequest)this.objectMapper.readValue(requestBody, CrowdUserSyncPreviewRequest.class);
        CrowdDirectoryConfiguration configuration = request.getDirectoryConfiguration();
        Directory directory = this.directoryMapper.buildCrowdDirectory(configuration);
        Directory directoryWithPassword = this.passwordRestoreUtil.restoreOldPasswordIfNewIsEmpty(configuration, directory);
        UserSyncPreviewResult userPreviewResult = this.userSyncPreviewService.getUserPreviewResult(directoryWithPassword, request);
        return Response.ok((Object)userPreviewResult).build();
    }

    public void setUserSyncPreviewService(UserSyncPreviewService userSyncPreviewService) {
        this.userSyncPreviewService = userSyncPreviewService;
    }

    public void setDirectoryMapper(DirectoryMapper directoryMapper) {
        this.directoryMapper = directoryMapper;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setPasswordRestoreUtil(PasswordRestoreUtil passwordRestoreUtil) {
        this.passwordRestoreUtil = passwordRestoreUtil;
    }

    void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    private void checkSysAdmin() {
        UserProfile remoteUser = this.userManager.getRemoteUser();
        if (remoteUser == null || !this.userManager.isSystemAdmin(remoteUser.getUserKey())) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }
}

