/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.ldap;

import com.atlassian.crowd.embedded.api.ConnectionPoolProperties;
import com.atlassian.crowd.embedded.impl.ConnectionPoolPropertyUtil;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Set;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapConnectionPoolValidator
implements Validator {
    public boolean supports(Class clazz) {
        return ConnectionPoolProperties.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        ConnectionPoolProperties configuration = (ConnectionPoolProperties)target;
        if (!ConnectionPoolPropertyUtil.isValidProtocol((String)configuration.getSupportedProtocol())) {
            errors.rejectValue("supportedProtocol", "invalid");
        }
        if (!ConnectionPoolPropertyUtil.isValidAuthentication((String)configuration.getSupportedAuthentication())) {
            errors.rejectValue("supportedAuthentication", "invalid");
        }
    }

    private boolean isValidEntry(String userInput, Set<String> validValues) {
        return validValues.containsAll((Collection<?>)ImmutableList.of((Object[])userInput.split(" ")));
    }
}

