/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.admin.crowd;

import com.atlassian.crowd.embedded.admin.ConfigurationController;
import com.atlassian.crowd.embedded.admin.crowd.CrowdDirectoryConfiguration;
import com.atlassian.crowd.embedded.admin.crowd.CrowdPermissionOption;
import com.atlassian.crowd.embedded.admin.plugin.PermissionOptionResolver;
import com.atlassian.crowd.embedded.api.Directory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.ServletRequestDataBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CrowdConfigurationController
extends ConfigurationController {
    private PermissionOptionResolver permissionOptionResolver;

    @Override
    protected Map referenceData(HttpServletRequest request) throws Exception {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("crowdPermissionOptions", this.getCrowdPermissionOptions());
        if (request.getPathInfo().endsWith("/crowd/")) {
            model.put("serverType", "crowd");
        } else {
            model.put("serverType", "jira");
        }
        return model;
    }

    @Override
    protected Directory createDirectory(Object command) {
        return this.directoryMapper.buildCrowdDirectory((CrowdDirectoryConfiguration)command);
    }

    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        if (this.directoryContextHelper.hasDirectoryId(request)) {
            Directory directory = this.directoryContextHelper.getDirectory(request);
            return this.directoryMapper.toCrowdConfiguration(directory);
        }
        CrowdDirectoryConfiguration configuration = (CrowdDirectoryConfiguration)this.createCommand();
        if (request.getPathInfo().endsWith("/crowd/")) {
            configuration.setName("Crowd Server");
        } else {
            configuration.setName("JIRA Server");
        }
        return configuration;
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        super.initBinder(request, binder);
        binder.setRequiredFields(new String[]{"name", "crowdServerUrl", "applicationName", "crowdPermissionOption", "crowdServerSynchroniseIntervalInMin"});
    }

    private List<String> getCrowdPermissionOptions() {
        ArrayList<String> options = new ArrayList<String>();
        for (CrowdPermissionOption option : this.permissionOptionResolver.getEnabledCrowdPermissionOptions()) {
            options.add(option.name());
        }
        return options;
    }

    public void setPermissionOptionResolver(PermissionOptionResolver permissionOptionResolver) {
        this.permissionOptionResolver = permissionOptionResolver;
    }
}

