/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.DirectoryTermKeys;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeTask421
implements UpgradeTask {
    private static final Logger log = Logger.getLogger(UpgradeTask421.class);
    private final Collection<String> errors = new ArrayList<String>();
    private DirectoryDao directoryDao;

    @Override
    public String getBuildNumber() {
        return "421";
    }

    @Override
    public String getShortDescription() {
        return "Upgrading Delegating Authentication Directories that don't have auto-create-on-auth flags";
    }

    @Override
    public void doUpgrade() throws Exception {
        for (Directory directory : this.findAllDelegatingAuthenticationDirectories()) {
            if (this.needsUpgrade(directory)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Upgrading directory " + directory));
                }
                try {
                    this.updateDirectory(directory);
                }
                catch (DataAccessException e) {
                    String errorMessage = "Could not update directory " + directory;
                    log.error((Object)errorMessage, (Throwable)e);
                    this.errors.add(errorMessage + ", error is " + e.getMessage());
                }
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("Directory " + directory + " will not be upgraded."));
        }
    }

    private void updateDirectory(Directory directory) throws DataAccessException, DirectoryNotFoundException {
        DirectoryImpl directoryToUpdate = new DirectoryImpl(directory);
        directoryToUpdate.setAttribute("crowd.delegated.directory.auto.create.user", Boolean.TRUE.toString());
        this.directoryDao.update((Directory)directoryToUpdate);
    }

    private boolean needsUpgrade(Directory directory) {
        return directory.getValue("crowd.delegated.directory.auto.create.user") == null;
    }

    public List<Directory> findAllDelegatingAuthenticationDirectories() {
        return this.directoryDao.search(QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory()).with((SearchRestriction)Restriction.on((Property)DirectoryTermKeys.TYPE).exactlyMatching((Object)DirectoryType.DELEGATING)).returningAtMost(-1));
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    public void setDirectoryDao(DirectoryDao directoryDao) {
        this.directoryDao = directoryDao;
    }
}

