/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.upgrade.tasks;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.password.encoder.AtlassianSHA1PasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.upgrade.tasks.UpgradeTask;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;

public class UpgradeTask114
implements UpgradeTask {
    private static final Logger logger = Logger.getLogger(UpgradeTask114.class);
    private Collection errors = new ArrayList();
    private ApplicationManager applicationManager;
    private PropertyManager propertyManager;
    private PasswordEncoderFactory passwordEncoderFactory;

    public String getBuildNumber() {
        return "114";
    }

    public String getShortDescription() {
        return "Upgrading application passwords from DES to Atlassian SHA-1";
    }

    public void doUpgrade() throws Exception {
        List applications = this.applicationManager.findAll();
        for (ApplicationImpl application : applications) {
            String sha1Applied = application.getValue("atlassian_sha1_applied");
            if (sha1Applied != null) continue;
            PasswordCredential credential = application.getCredential();
            String credentialValue = credential.getCredential();
            PasswordCredential unencryptedCredential = new PasswordCredential(this.decryptCredential(credentialValue));
            logger.info((Object)("Re-encrypting credentials for application: " + application.getName()));
            PasswordCredential encryptedCredential = this.encryptCredential(unencryptedCredential);
            application.setCredential(encryptedCredential);
            application.setAttribute("atlassian_sha1_applied", Boolean.TRUE.toString());
            this.applicationManager.update((Application)application);
        }
    }

    private PasswordCredential encryptCredential(PasswordCredential passwordCredential) {
        AtlassianSHA1PasswordEncoder encoder = new AtlassianSHA1PasswordEncoder();
        String encryptedPassword = encoder.encodePassword(passwordCredential.getCredential(), null);
        return new PasswordCredential(encryptedPassword, true);
    }

    protected String decryptCredential(String encryptedCredential) throws PropertyManagerException, IOException, GeneralSecurityException {
        String unencryptedCredential = null;
        Key encryptionKey = null;
        try {
            encryptionKey = this.propertyManager.getDesEncryptionKey();
        }
        catch (PropertyManagerException e) {
            this.errors.add("Failed to find encryption key due too: " + e.getMessage());
            throw e;
        }
        Cipher dcipher = null;
        ByteArrayInputStream bis = null;
        InputStream in = null;
        ByteArrayOutputStream bos = null;
        try {
            try {
                dcipher = Cipher.getInstance("DES");
                dcipher.init(2, encryptionKey);
            }
            catch (GeneralSecurityException e) {
                this.errors.add("Failed to create Cipher: " + e.getMessage());
                throw e;
            }
            bis = new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(encryptedCredential));
            in = new CipherInputStream(bis, dcipher);
            int numRead = 0;
            bos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((numRead = in.read(buf)) >= 0) {
                bos.write(buf, 0, numRead);
            }
            unencryptedCredential = new String(bos.toByteArray());
        }
        catch (IOException e) {
            this.errors.add(e.getMessage());
            throw e;
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (in != null) {
                    in.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {}
        }
        return unencryptedCredential;
    }

    public Collection getErrors() {
        return this.errors;
    }

    public void setApplicationManager(ApplicationManager applicationManager) {
        this.applicationManager = applicationManager;
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setPasswordEncoderFactory(PasswordEncoderFactory passwordEncoderFactory) {
        this.passwordEncoderFactory = passwordEncoderFactory;
    }
}

