/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.manager.login.util;

import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.mail.MailManager;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.util.I18nHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForgottenLoginMailer {
    public static final String USERNAME_MACRO = "$username";
    public static final String FIRSTNAME_MACRO = "$firstname";
    public static final String LASTNAME_MACRO = "$lastname";
    public static final String DEPLOYMENTTITLE_MACRO = "$deploymenttitle";
    public static final String DATE_MACRO = "$date";
    public static final String PASSWORD_MACRO = "$password";
    public static final String RESET_LINK_MACRO = "$resetlink";
    public static final String EMAIL_MACRO = "$email";
    public static final String ADMIN_CONTACT_MACRO = "$admincontact";
    private static final String MAILER_FORGOT_PASSWORD_SUBJECT = "forgottenpassword.subject";
    private static final String MAILER_FORGOT_USERNAME_SUBJECT = "forgottenusername.subject";
    private static final String AVAILABLE_AT_TEXT = "mailtemplate.template.forgotten.password.availableat.text";
    private final PropertyManager propertyManager;
    private final MailManager mailManager;
    private final I18nHelper i18nHelper;

    public ForgottenLoginMailer(PropertyManager propertyManager, MailManager mailManager, I18nHelper i18nHelper) {
        this.propertyManager = (PropertyManager)Preconditions.checkNotNull((Object)propertyManager);
        this.mailManager = (MailManager)Preconditions.checkNotNull((Object)mailManager);
        this.i18nHelper = (I18nHelper)Preconditions.checkNotNull((Object)i18nHelper);
    }

    public void mailResetPasswordLink(User user, String resetLink) throws InvalidEmailAddressException, MailSendException {
        Validate.notNull((Object)user, (String)"User cannot be null");
        Validate.notNull((Object)resetLink, (String)"Reset link cannot be null");
        Preconditions.checkNotNull((Object)user.getEmailAddress(), (Object)"User's email cannot be null");
        try {
            String messageTemplate;
            try {
                messageTemplate = this.propertyManager.getProperty("mailserver.message.template");
            }
            catch (ObjectNotFoundException e) {
                throw new MailSendException(e);
            }
            String email = user.getEmailAddress();
            InternetAddress emailAddress = new InternetAddress(email);
            emailAddress.validate();
            LinkedHashMap<String, String> macroReplacementMap = new LinkedHashMap<String, String>();
            macroReplacementMap.put(FIRSTNAME_MACRO, user.getFirstName());
            macroReplacementMap.put(LASTNAME_MACRO, user.getLastName());
            macroReplacementMap.put(USERNAME_MACRO, user.getName());
            macroReplacementMap.put(RESET_LINK_MACRO, resetLink);
            macroReplacementMap.put(PASSWORD_MACRO, this.i18nHelper.getText(AVAILABLE_AT_TEXT) + " " + resetLink);
            macroReplacementMap.put(DEPLOYMENTTITLE_MACRO, this.propertyManager.getDeploymentTitle());
            macroReplacementMap.put(DATE_MACRO, new Date().toString());
            messageTemplate = ForgottenLoginMailer.replaceMacros(messageTemplate, macroReplacementMap);
            this.mailManager.sendEmail(emailAddress, this.i18nHelper.getText(MAILER_FORGOT_PASSWORD_SUBJECT), messageTemplate);
        }
        catch (AddressException e) {
            throw new InvalidEmailAddressException(e.getMessage(), (Throwable)e);
        }
        catch (PropertyManagerException e) {
            throw new MailSendException(e);
        }
    }

    public void mailUsernames(User user, List<String> usernames) throws InvalidEmailAddressException, MailSendException {
        Validate.notNull((Object)user, (String)"User cannot be null");
        Validate.notEmpty(usernames);
        Preconditions.checkNotNull((Object)user.getEmailAddress(), (Object)"User's email cannot be null");
        try {
            String email = user.getEmailAddress();
            InternetAddress emailAddress = new InternetAddress(email);
            emailAddress.validate();
            String messageTemplate = this.propertyManager.getProperty("email.template.forgotten.username");
            String formattedUsernames = Joiner.on((String)", ").join(usernames);
            LinkedHashMap<String, String> macroReplacementMap = new LinkedHashMap<String, String>();
            macroReplacementMap.put(FIRSTNAME_MACRO, user.getFirstName());
            macroReplacementMap.put(LASTNAME_MACRO, user.getLastName());
            macroReplacementMap.put(USERNAME_MACRO, formattedUsernames);
            macroReplacementMap.put(DEPLOYMENTTITLE_MACRO, this.propertyManager.getDeploymentTitle());
            macroReplacementMap.put(DATE_MACRO, new Date().toString());
            macroReplacementMap.put(EMAIL_MACRO, email);
            macroReplacementMap.put(ADMIN_CONTACT_MACRO, this.propertyManager.getProperty("notification.email"));
            messageTemplate = ForgottenLoginMailer.replaceMacros(messageTemplate, macroReplacementMap);
            this.mailManager.sendEmail(emailAddress, this.i18nHelper.getText(MAILER_FORGOT_USERNAME_SUBJECT), messageTemplate);
        }
        catch (AddressException e) {
            throw new InvalidEmailAddressException((Throwable)e);
        }
        catch (PropertyManagerException e) {
            throw new MailSendException(e);
        }
        catch (ObjectNotFoundException e) {
            throw new MailSendException(e);
        }
    }

    private static String replaceMacros(String messageTemplate, Map<String, String> macroReplacementMap) {
        Validate.notNull((Object)messageTemplate);
        for (Map.Entry<String, String> replacementEntry : macroReplacementMap.entrySet()) {
            String extra = "";
            if (replacementEntry.getValue() == null) {
                extra = "\\s";
            }
            String toFind = "(" + extra + "\\" + replacementEntry.getKey() + "){1}";
            messageTemplate = messageTemplate.replaceAll(toFind, replacementEntry.getValue());
        }
        return messageTemplate;
    }
}

