/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.event.listener;

import com.atlassian.crowd.event.EventJobExecutionException;
import com.atlassian.crowd.event.user.ResetPasswordEvent;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.manager.mail.MailManager;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.event.api.EventListener;
import java.util.Date;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;

public class ResetPasswordListener {
    public static final String RESET_PASSWORD = "password";
    public static final String INVALID_EMAIL_EXCEPTION_MESSAGE = "Invalid email address, can not reset password.";
    public static final String USERNAME_MACRO = "$username";
    public static final String FIRSTNAME_MACRO = "$firstname";
    public static final String LASTNAME_MACRO = "$lastname";
    public static final String DEPLOYMENTTITLE_MACRO = "$deploymenttitle";
    public static final String DATE_MACRO = "$date";
    public static final String PASSWORD_MACRO = "$password";
    private static final String MAILER_SUBJECT = "reset.password.subject";
    private PropertyManager propertyManager;
    private MailManager mailManager;
    private I18nHelper i18nHelper;

    @EventListener
    public void handleEvent(ResetPasswordEvent resetPasswordEvent) throws ObjectNotFoundException {
        try {
            String messageTemplate = this.propertyManager.getProperty("mailserver.message.template");
            User user = resetPasswordEvent.getUser();
            String email = user.getEmailAddress();
            if (user.getFirstName() == null || user.getLastName() == null) {
                messageTemplate = messageTemplate.replaceAll("(\\s\\$firstname){1}", "");
                messageTemplate = messageTemplate.replaceAll("(\\s\\$lastname){1}", "");
            } else {
                messageTemplate = messageTemplate.replaceAll("(\\$firstname){1}", user.getFirstName());
                messageTemplate = messageTemplate.replaceAll("(\\$lastname){1}", user.getLastName());
            }
            messageTemplate = messageTemplate.replaceAll("(\\$username){1}", user.getName());
            messageTemplate = messageTemplate.replaceAll("(\\$password){1}", resetPasswordEvent.getNewPassword());
            messageTemplate = messageTemplate.replaceAll("(\\$deploymenttitle){1}", this.propertyManager.getDeploymentTitle());
            messageTemplate = messageTemplate.replaceAll("(\\$date){1}", new Date(resetPasswordEvent.getTimestamp()).toString());
            this.mailManager.sendEmail(new InternetAddress(email), this.i18nHelper.getText(MAILER_SUBJECT), messageTemplate);
        }
        catch (PropertyManagerException e) {
            throw new EventJobExecutionException(e.getMessage(), e);
        }
        catch (AddressException e) {
            throw new EventJobExecutionException(e.getMessage(), e);
        }
        catch (MailSendException e) {
            throw new EventJobExecutionException(e.getMessage(), e);
        }
    }

    public void setPropertyManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public void setMailManager(MailManager mailManager) {
        this.mailManager = mailManager;
    }

    public void setI18nHelper(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }
}

