/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.atlassian.crowd.plugin.rest.entity.AuthenticationContextEntity;
import com.atlassian.crowd.plugin.rest.entity.SessionEntity;
import com.atlassian.crowd.plugin.rest.entity.ValidationFactorEntity;
import com.atlassian.crowd.plugin.rest.entity.ValidationFactorEntityList;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;

public class TokenResourceTest
extends RestCrowdServiceAcceptanceTestCase {
    private static final String USERNAME = "admin";
    private static final String PASSWORD = "admin";
    private static final String BAD_PASSWORD = "bad_password";
    private static final ValidationFactorEntity restFactor1 = new ValidationFactorEntity("remote_address", "127.0.0.1");
    private static final ValidationFactorEntity restFactor2 = new ValidationFactorEntity("remote_host", "blah");
    private static final ValidationFactorEntityList restFactors;

    public TokenResourceTest(String name) {
        super(name);
    }

    public TokenResourceTest(String name, RestServer restServer) {
        super(name, restServer);
    }

    public void testUserAuthentication() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        AuthenticationContextEntity authContext = new AuthenticationContextEntity("admin", "admin", restFactors);
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)authContext);
        TokenResourceTest.assertEquals((int)201, (int)response.getStatus());
    }

    public void testUserAuthentication_WithoutPasswordValidation() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session").queryParam("validate-password", "false");
        AuthenticationContextEntity authContext = new AuthenticationContextEntity("admin", null, restFactors);
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)authContext);
        TokenResourceTest.assertEquals((int)201, (int)response.getStatus());
    }

    public void testInvalidUserAuthentication() {
        block2: {
            WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
            AuthenticationContextEntity authContext = new AuthenticationContextEntity("admin", BAD_PASSWORD, restFactors);
            try {
                webResource.post(SessionEntity.class, (Object)authContext);
                TokenResourceTest.fail((String)"Should have failed authentication and thrown a UniformInterfaceException.");
            }
            catch (UniformInterfaceException e) {
                if (e.getResponse().getStatus() == Response.Status.BAD_REQUEST.getStatusCode()) break block2;
                TokenResourceTest.fail((String)("Should have returned a " + Response.Status.BAD_REQUEST.getStatusCode() + " status code."));
            }
        }
    }

    public void testGetUserFromToken() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        AuthenticationContextEntity authContext = new AuthenticationContextEntity("admin", "admin", restFactors);
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)authContext);
        TokenResourceTest.assertEquals((int)201, (int)response.getStatus());
        webResource = this.getWebResource("crowd", "qybhDMZh", response.getLocation());
        SessionEntity session = (SessionEntity)webResource.get(SessionEntity.class);
        TokenResourceTest.assertEquals((String)"admin", (String)session.getUser().getName());
    }

    public void testValidateToken() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        AuthenticationContextEntity authContext = new AuthenticationContextEntity("admin", "admin", restFactors);
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)authContext);
        TokenResourceTest.assertEquals((int)201, (int)response.getStatus());
        webResource = this.getWebResource("crowd", "qybhDMZh", response.getLocation());
        webResource.post((Object)restFactors);
    }

    public void testValidateToken_InvalidToken() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session").path("invalidtoken");
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)restFactors);
        TokenResourceTest.assertEquals((int)404, (int)response.getStatus());
    }

    public void testValidateToken_InvalidValidationFactors() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        ValidationFactorEntity wrongFac = new ValidationFactorEntity("remote_address", "wrongFactor");
        ValidationFactorEntityList wrongFactors = new ValidationFactorEntityList(Arrays.asList(wrongFac));
        AuthenticationContextEntity authContext = new AuthenticationContextEntity("admin", "admin", restFactors);
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)authContext);
        TokenResourceTest.assertEquals((int)201, (int)response.getStatus());
        webResource = this.getWebResource("crowd", "qybhDMZh", response.getLocation());
        response = (ClientResponse)webResource.post(ClientResponse.class, (Object)wrongFactors);
        TokenResourceTest.assertEquals((int)400, (int)response.getStatus());
    }

    public void testInvalidateToken() {
        WebResource webResource = this.getRootWebResource("crowd", "qybhDMZh").path("session");
        AuthenticationContextEntity authContext = new AuthenticationContextEntity("admin", "admin", restFactors);
        ClientResponse response = (ClientResponse)webResource.post(ClientResponse.class, (Object)authContext);
        URI uri = response.getLocation();
        TokenResourceTest.assertEquals((int)201, (int)response.getStatus());
        webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        response = (ClientResponse)webResource.delete(ClientResponse.class);
        TokenResourceTest.assertEquals((int)204, (int)response.getStatus());
        webResource = this.getWebResource("crowd", "qybhDMZh", uri);
        response = (ClientResponse)webResource.post(ClientResponse.class, (Object)restFactors);
        TokenResourceTest.assertEquals((int)404, (int)response.getStatus());
    }

    static {
        List<ValidationFactorEntity> factors = Arrays.asList(restFactor1, restFactor2);
        restFactors = new ValidationFactorEntityList(factors);
    }
}

