/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.rest.service;

import com.atlassian.crowd.acceptance.rest.RestServer;
import com.atlassian.crowd.acceptance.tests.rest.service.RestCrowdServiceAcceptanceTestCase;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.plugin.rest.entity.ErrorEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.NullRestrictionEntity;
import com.atlassian.crowd.plugin.rest.entity.SearchRestrictionEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntityList;
import com.atlassian.crowd.plugin.rest.util.SearchRestrictionEntityTranslator;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.google.common.collect.Sets;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Response;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResourceTest
extends RestCrowdServiceAcceptanceTestCase {
    private static final String APPLICATION_NAME = "crowd";
    private static final String SEARCH_RESOURCE = "search";
    private static final String START_INDEX_PARAM = "start-index";
    private static final String MAX_RESULT_PARAM = "max-results";
    private static final String ENTITY_TYPE_PARAM = "entity-type";
    private static final String USER_ENTITY_TYPE = "user";
    private static final String GROUP_ENTITY_TYPE = "group";
    private static final String EXPAND_PARAM = "expand";
    private static final String USER_PARAM_VALUE = "user";
    private static final String GROUP_PARAM_VALUE = "group";
    private static final String USERNAME1 = "admin";
    private static final String USERNAME2 = "eeeep";
    private static final String USERNAME3 = "penny";
    private static final String USERNAME4 = "regularuser";
    private static final String USERNAME5 = "secondadmin";
    private static final String USERNAME6 = "dir1user";
    private static final String GROUP1 = "animals";
    private static final String GROUP2 = "badgers";
    private static final String GROUP3 = "birds";
    private static final String GROUP4 = "cats";
    private static final String GROUP5 = "crowd-administrators";
    private static final String GROUP6 = "crowd-testers";
    private static final String GROUP7 = "crowd-users";
    private static final String GROUP8 = "dogs";
    private static final String EMAIL1 = "bob@example.net";
    private static final String NON_EXISTENT_EMAIL = "nosuchemail@nosuchemail.com";
    private static final int TOTAL_NUM_USERS;
    private static final Set<String> ALL_USERNAMES;
    private static final int TOTAL_NUM_GROUPS;
    private static final Set<String> ALL_GROUPNAMES;
    private static final String ALIAS_APPLICATION_NAME = "aliases";
    private static final String ALIAS_APPLICATION_PASSWORD = "aliases";

    public SearchResourceTest(String name) {
        super(name);
    }

    public SearchResourceTest(String name, RestServer restServer) {
        super(name, restServer);
    }

    public void testGetUnknownEntityType() throws Exception {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"UNKNOWN"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        Response.Status expectedStatus = Response.Status.BAD_REQUEST;
        try {
            webResource.post(UserEntityList.class, (Object)NullRestrictionEntity.INSTANCE);
            SearchResourceTest.fail((String)(expectedStatus + " expected"));
        }
        catch (UniformInterfaceException e) {
            ErrorEntity errorEntity = (ErrorEntity)e.getResponse().getEntity(ErrorEntity.class);
            SearchResourceTest.assertEquals((Object)ErrorEntity.ErrorReason.ILLEGAL_ARGUMENT, (Object)errorEntity.getReason());
            SearchResourceTest.assertEquals((int)expectedStatus.getStatusCode(), (int)e.getResponse().getStatus());
        }
    }

    public void testGetUserNames() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        UserEntityList users = (UserEntityList)webResource.post(UserEntityList.class, (Object)NullRestrictionEntity.INSTANCE);
        Set<String> userNames = SearchResourceTest.getNames(users);
        SearchResourceTest.assertEquals(ALL_USERNAMES, userNames);
    }

    public void testGetUserNames_MaxResult() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(MAX_RESULT_PARAM, new Object[]{"3"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        UserEntityList users = (UserEntityList)webResource.post(UserEntityList.class, (Object)NullRestrictionEntity.INSTANCE);
        Set<String> userNames = SearchResourceTest.getNames(users);
        SearchResourceTest.assertEquals((int)3, (int)userNames.size());
    }

    public void testGetUserNames_StartIndex() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(START_INDEX_PARAM, new Object[]{"3"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        UserEntityList users = (UserEntityList)webResource.post(UserEntityList.class, (Object)NullRestrictionEntity.INSTANCE);
        Set<String> userNames = SearchResourceTest.getNames(users);
        SearchResourceTest.assertEquals((int)(TOTAL_NUM_USERS - 3), (int)userNames.size());
    }

    public void testGetUserNames_Aliases() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource("aliases", "aliases", uri);
        UserEntityList users = (UserEntityList)webResource.post(UserEntityList.class, (Object)SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)"alias")));
        Set<String> userNames = SearchResourceTest.getNames(users);
        SearchResourceTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"alias1", "alias2", "alias3"}), userNames);
    }

    public void testGetUserNames_AliasesIgnoreUsernameWhenAliasExists() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource("aliases", "aliases", uri);
        UserEntityList users = (UserEntityList)webResource.post(UserEntityList.class, (Object)SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)USERNAME1)));
        Set<String> userNames = SearchResourceTest.getNames(users);
        SearchResourceTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{USERNAME5}), userNames);
    }

    public void testGetUserNames_AliasesAll() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource("aliases", "aliases", uri);
        UserEntityList users = (UserEntityList)webResource.post(UserEntityList.class, (Object)SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)"a")));
        Set<String> userNames = SearchResourceTest.getNames(users);
        SearchResourceTest.assertEquals((Object)Sets.newHashSet((Object[])new String[]{"alias1", "alias2", "alias3", USERNAME5}), userNames);
    }

    public void testGetUserNames_NegativeStartIndex() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(START_INDEX_PARAM, new Object[]{"-1"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        try {
            webResource.post(UserEntityList.class, (Object)NullRestrictionEntity.INSTANCE);
            SearchResourceTest.fail((String)"Should have returned a Bad Request Error (400) status.");
        }
        catch (UniformInterfaceException e) {
            ClientResponse response = e.getResponse();
            SearchResourceTest.assertEquals((String)"Should have returned a Bad Request Error (400) status.", (int)Response.Status.BAD_REQUEST.getStatusCode(), (int)response.getStatus());
        }
    }

    public void testGetUserNames_EmailRestriction() {
        PropertyRestriction emailRestriction = Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)EMAIL1);
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        SearchRestrictionEntity restriction = SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)emailRestriction);
        UserEntityList users = (UserEntityList)webResource.post(UserEntityList.class, (Object)restriction);
        Set<String> usernames = SearchResourceTest.getNames(users);
        HashSet expectedUsernames = Sets.newHashSet((Object[])new String[]{USERNAME1, USERNAME4});
        SearchResourceTest.assertEquals((Object)expectedUsernames, usernames);
        PropertyRestriction nonExistentEmailRestriction = Restriction.on((Property)UserTermKeys.EMAIL).exactlyMatching((Object)NON_EXISTENT_EMAIL);
        SearchRestrictionEntity restRestriction = SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)nonExistentEmailRestriction);
        users = (UserEntityList)webResource.post(UserEntityList.class, (Object)restRestriction);
        usernames = SearchResourceTest.getNames(users);
        SearchResourceTest.assertTrue((boolean)usernames.isEmpty());
    }

    public void testGetUsers() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(EXPAND_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        UserEntityList users = (UserEntityList)webResource.post(UserEntityList.class, (Object)NullRestrictionEntity.INSTANCE);
        SearchResourceTest.assertEquals((int)TOTAL_NUM_USERS, (int)users.size());
    }

    public void testGetUsers_UserRestriction() {
        PropertyRestriction usernameRestriction = Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)USERNAME2);
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(EXPAND_PARAM, new Object[]{"user"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        SearchRestrictionEntity restriction = SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)usernameRestriction);
        UserEntityList users = (UserEntityList)webResource.post(UserEntityList.class, (Object)restriction);
        SearchResourceTest.assertEquals((int)1, (int)users.size());
        SearchResourceTest.assertEquals((String)USERNAME2, (String)users.get(0).getName());
        SearchResourceTest.assertEquals((String)"doflynn@atlassian.com", (String)users.get(0).getEmail());
    }

    public void testGetUser_StartIndex() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"user"}).queryParam(EXPAND_PARAM, new Object[]{"user"}).queryParam(START_INDEX_PARAM, new Object[]{"3"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        UserEntityList users = (UserEntityList)webResource.post(UserEntityList.class, (Object)NullRestrictionEntity.INSTANCE);
        SearchResourceTest.assertEquals((int)(TOTAL_NUM_USERS - 3), (int)users.size());
    }

    public void testGetGroupNames() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"group"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        GroupEntityList groups = (GroupEntityList)webResource.post(GroupEntityList.class, (Object)NullRestrictionEntity.INSTANCE);
        Set<String> groupNames = SearchResourceTest.getNames(groups);
        SearchResourceTest.assertEquals(ALL_GROUPNAMES, groupNames);
    }

    public void testGetGroupNames_Restricted() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"group"}).queryParam(MAX_RESULT_PARAM, new Object[]{"3"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        GroupEntityList groups = (GroupEntityList)webResource.post(GroupEntityList.class, (Object)NullRestrictionEntity.INSTANCE);
        Set<String> groupNames = SearchResourceTest.getNames(groups);
        SearchResourceTest.assertEquals((int)3, (int)groupNames.size());
    }

    public void testGetGroupNames_StartIndex() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"group"}).queryParam(START_INDEX_PARAM, new Object[]{"3"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        GroupEntityList groups = (GroupEntityList)webResource.post(GroupEntityList.class, (Object)NullRestrictionEntity.INSTANCE);
        Set<String> groupNames = SearchResourceTest.getNames(groups);
        SearchResourceTest.assertEquals((int)(TOTAL_NUM_GROUPS - 3), (int)groupNames.size());
    }

    public void testGetGroupNames_ActiveRestriction() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"group"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        PropertyRestriction groupActiveRestriction = Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching((Object)true);
        SearchRestrictionEntity restriction = SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)groupActiveRestriction);
        GroupEntityList groups = (GroupEntityList)webResource.post(GroupEntityList.class, (Object)restriction);
        Set<String> groupNames = SearchResourceTest.getNames(groups);
        SearchResourceTest.assertEquals(ALL_GROUPNAMES, groupNames);
        groupActiveRestriction = Restriction.on((Property)GroupTermKeys.ACTIVE).exactlyMatching((Object)false);
        restriction = SearchRestrictionEntityTranslator.toSearchRestrictionEntity((SearchRestriction)groupActiveRestriction);
        groups = (GroupEntityList)webResource.post(GroupEntityList.class, (Object)restriction);
        groupNames = SearchResourceTest.getNames(groups);
        SearchResourceTest.assertTrue((boolean)groupNames.isEmpty());
    }

    public void testGetGroups() {
        URI uri = this.getBaseUriBuilder().path(SEARCH_RESOURCE).queryParam(ENTITY_TYPE_PARAM, new Object[]{"group"}).queryParam(EXPAND_PARAM, new Object[]{"group"}).build(new Object[0]);
        WebResource webResource = this.getWebResource(APPLICATION_NAME, "qybhDMZh", uri);
        GroupEntityList groups = (GroupEntityList)webResource.post(GroupEntityList.class, (Object)NullRestrictionEntity.INSTANCE);
        SearchResourceTest.assertEquals((int)TOTAL_NUM_GROUPS, (int)groups.size());
    }

    private static Set<String> getNames(UserEntityList users) {
        HashSet usernames = Sets.newHashSet();
        for (UserEntity user : users) {
            usernames.add(user.getName());
        }
        return usernames;
    }

    private static Set<String> getNames(GroupEntityList groups) {
        HashSet groupnames = Sets.newHashSet();
        for (GroupEntity group : groups) {
            groupnames.add(group.getName());
        }
        return groupnames;
    }

    static {
        ALL_USERNAMES = Sets.newHashSet((Object[])new String[]{USERNAME1, USERNAME2, USERNAME3, USERNAME4, USERNAME5, USERNAME6});
        TOTAL_NUM_USERS = ALL_USERNAMES.size();
        ALL_GROUPNAMES = Sets.newHashSet((Object[])new String[]{GROUP1, GROUP2, GROUP3, GROUP4, GROUP5, GROUP6, GROUP7, GROUP8});
        TOTAL_NUM_GROUPS = ALL_GROUPNAMES.size();
    }
}

