/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.controller;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationService;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.filter.AuthenticatedApplicationHolder;
import com.atlassian.crowd.plugin.rest.service.controller.AbstractResourceController;
import com.atlassian.crowd.plugin.rest.util.EntityTranslator;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.Link;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class AuthenticationController
extends AbstractResourceController {
    private final ApplicationService applicationService;

    @Inject
    public AuthenticationController(@ComponentImport ApplicationService applicationService, AuthenticatedApplicationHolder authenticatedApplicationHolder) {
        super(authenticatedApplicationHolder);
        this.applicationService = applicationService;
    }

    public UserEntity authenticateUser(String username, PasswordEntity password, URI baseUri) throws UserNotFoundException, ExpiredCredentialException, InactiveAccountException, InvalidAuthenticationException, OperationFailedException {
        Application application = this.getAuthenticatedApplication();
        User user = this.applicationService.authenticateUser(application, username, PasswordCredential.unencrypted((String)password.getValue()));
        this.checkAuthorised(user, application);
        return this.mapToEntity(user, baseUri);
    }

    public UserEntity userAuthenticated(String username, URI baseUri) throws UserNotFoundException, OperationFailedException, InactiveAccountException, InvalidAuthenticationException {
        Application application = this.getAuthenticatedApplication();
        User user = this.applicationService.userAuthenticated(application, username);
        this.checkAuthorised(user, application);
        return this.mapToEntity(user, baseUri);
    }

    private UserEntity mapToEntity(User user, URI baseUri) {
        Link userLink = LinkUriHelper.buildUserLink(baseUri, user.getName());
        return EntityTranslator.toUserEntity(user, userLink);
    }

    private void checkAuthorised(User user, Application application) throws InvalidAuthenticationException {
        if (!this.applicationService.isUserAuthorised(application, user.getName())) {
            throw new InvalidAuthenticationException("User is not allowed to authenticate with the application");
        }
    }
}

