/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.filter;

import com.atlassian.crowd.audit.AuditLogAuthor;
import com.atlassian.crowd.audit.AuditLogAuthorType;
import com.atlassian.crowd.audit.AuditLogContext;
import com.atlassian.crowd.audit.AuditLogContextCallback;
import com.atlassian.crowd.audit.ImmutableAuditLogAuthor;
import com.atlassian.crowd.common.util.SystemProperties;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.authentication.TokenAuthenticationManager;
import com.atlassian.crowd.manager.validation.ClientValidationException;
import com.atlassian.crowd.manager.validation.ClientValidationManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ImmutableApplication;
import com.atlassian.crowd.model.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.model.token.Token;
import com.atlassian.crowd.model.token.TokenLifetime;
import com.atlassian.crowd.plugin.rest.filter.AuthenticatedApplicationHolder;
import com.atlassian.crowd.plugin.rest.filter.BasicAuthenticationHelper;
import com.atlassian.crowd.plugin.rest.filter.ChainFilterAuditLogContextCallback;
import com.atlassian.crowd.plugin.rest.service.util.AuthenticatedApplicationUtil;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Throwables;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class BasicApplicationAuthenticationFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(BasicApplicationAuthenticationFilter.class);
    private static final String CHALLENGE_MSG = "Application failed to authenticate";
    private static final String BASIC_AUTH_REALM = "Crowd REST Service";
    private static final TokenLifetime APPLICATION_TOKEN_LIFETIME = TokenLifetime.inSeconds((long)60L);
    private final ApplicationManager applicationManager;
    private final ClientValidationManager clientValidationManager;
    private final TokenAuthenticationManager tokenAuthenticationManager;
    private final AuthenticatedApplicationHolder authenticatedApplicationHolder;
    private final AuditLogContext auditLogContext;

    @Inject
    public BasicApplicationAuthenticationFilter(@ComponentImport ApplicationManager applicationManager, @ComponentImport ClientValidationManager clientValidationManager, @ComponentImport TokenAuthenticationManager tokenAuthenticationManager, @ComponentImport AuditLogContext auditLogContext, AuthenticatedApplicationHolder authenticatedApplicationHolder) {
        this.applicationManager = applicationManager;
        this.clientValidationManager = clientValidationManager;
        this.tokenAuthenticationManager = tokenAuthenticationManager;
        this.authenticatedApplicationHolder = authenticatedApplicationHolder;
        this.auditLogContext = auditLogContext;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        BasicAuthenticationHelper.Credentials credentials = BasicAuthenticationHelper.getBasicAuthCredentials(request);
        try {
            if (credentials == null) {
                LOG.debug("No basic auth credentials found in request, responding with authentication challenge");
                BasicAuthenticationHelper.respondWithChallenge(response, CHALLENGE_MSG, BASIC_AUTH_REALM);
            } else {
                try {
                    ImmutableApplication application = ImmutableApplication.from((Application)this.applicationManager.findByName(credentials.getName()));
                    this.clientValidationManager.validate((Application)application, request);
                    if (this.isAuthenticated(request, credentials)) {
                        LOG.debug("Application '{}' is already authenticated", (Object)credentials.getName());
                    } else {
                        Token token = this.authenticate((Application)application, credentials.getPassword());
                        LOG.debug("Application '{}' authenticated successfully", (Object)credentials.getName());
                        AuthenticatedApplicationUtil.setAuthenticatedApplication(request, credentials.getName());
                        if (token != null) {
                            AuthenticatedApplicationUtil.setAuthenticatedApplicationToken(request, token);
                        }
                    }
                    if (SystemProperties.isAppnameHeaderInResponsesEnabled()) {
                        ((HttpServletResponse)servletResponse).setHeader("X-AAPPNAME", application.getName());
                    }
                    this.authenticatedApplicationHolder.setAuthenticatedApplication(application);
                    this.executeOnBehalfOfApplication(chain, request, response, application);
                }
                catch (ApplicationNotFoundException e) {
                    LOG.info("Application '{}' failed authentication", (Object)credentials.getName());
                    BasicAuthenticationHelper.respondWithChallenge(response, CHALLENGE_MSG, BASIC_AUTH_REALM);
                }
                catch (InvalidAuthenticationException e) {
                    LOG.info("Invalid authentication for application with name '{}'", (Object)credentials.getName());
                    BasicAuthenticationHelper.respondWithChallenge(response, CHALLENGE_MSG, BASIC_AUTH_REALM);
                }
                catch (ClientValidationException e) {
                    response.sendError(403, e.getMessage());
                }
            }
        }
        finally {
            this.authenticatedApplicationHolder.clear();
        }
    }

    private void executeOnBehalfOfApplication(FilterChain chain, HttpServletRequest request, HttpServletResponse response, ImmutableApplication application) throws IOException, ServletException {
        try {
            this.auditLogContext.withAuditLogAuthor((AuditLogAuthor)new ImmutableAuditLogAuthor(application.getId(), application.getName(), AuditLogAuthorType.APPLICATION), (AuditLogContextCallback)new ChainFilterAuditLogContextCallback(chain, request, response));
        }
        catch (Exception e) {
            Throwables.propagateIfPossible((Throwable)e, IOException.class, ServletException.class);
            throw new RuntimeException(e);
        }
    }

    public void destroy() {
    }

    @Nullable
    private Token authenticate(Application application, String password) throws InvalidAuthenticationException, ApplicationNotFoundException {
        ApplicationAuthenticationContext authenticationContext = new ApplicationAuthenticationContext(application.getName(), PasswordCredential.unencrypted((String)password), new ValidationFactor[0]);
        Token token = this.tokenAuthenticationManager.authenticateApplication(application, authenticationContext, APPLICATION_TOKEN_LIFETIME);
        if (token == null && !this.applicationManager.authenticate(application, PasswordCredential.unencrypted((String)password))) {
            throw InvalidAuthenticationException.newInstanceWithName((String)application.getName());
        }
        return token;
    }

    private boolean isAuthenticated(HttpServletRequest request, BasicAuthenticationHelper.Credentials credentials) {
        Token token = AuthenticatedApplicationUtil.getAuthenticatedApplicationToken(request);
        if (token != null) {
            try {
                this.tokenAuthenticationManager.validateApplicationToken(token.getRandomHash(), new ValidationFactor[0]);
            }
            catch (InvalidTokenException e) {
                return false;
            }
        }
        return credentials.getName().equals(AuthenticatedApplicationUtil.getAuthenticatedApplication(request));
    }
}

