/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource;

import com.atlassian.crowd.plugin.rest.service.util.AuthenticatedApplicationUtil;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

public class AbstractResource {
    @Context
    protected UriInfo uriInfo;
    @Context
    protected HttpServletRequest request;

    protected String getApplicationName() {
        String applicationName = AuthenticatedApplicationUtil.getAuthenticatedApplication(this.request);
        if (applicationName == null) {
            throw new IllegalStateException("Application name was not set as an attribute in the HttpSession");
        }
        return applicationName;
    }

    @VisibleForTesting
    protected void setApplicationName(String applicationName) {
        AuthenticatedApplicationUtil.setAuthenticatedApplication(this.request, applicationName);
    }

    @VisibleForTesting
    public void setRequest(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
    }

    @VisibleForTesting
    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    protected URI getBaseUri() {
        return this.uriInfo.getBaseUri();
    }
}

