/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.util;

import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.plugin.rest.entity.GroupEntity;
import com.atlassian.crowd.plugin.rest.entity.GroupEntityList;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntity;
import com.atlassian.crowd.plugin.rest.entity.MultiValuedAttributeEntityList;
import com.atlassian.crowd.plugin.rest.entity.PasswordEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntity;
import com.atlassian.crowd.plugin.rest.entity.UserEntityList;
import com.atlassian.crowd.plugin.rest.util.LinkUriHelper;
import com.atlassian.plugins.rest.common.Link;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTranslator {
    private EntityTranslator() {
    }

    public static UserEntity toUserEntity(User user, Link userLink) {
        if (user == null) {
            return null;
        }
        Validate.notNull((Object)userLink);
        UserEntity userEntity = new UserEntity(user.getName(), user.getFirstName(), user.getLastName(), user.getDisplayName(), user.getEmailAddress(), null, user.isActive(), userLink);
        userEntity.setAttributes(EntityTranslator.getEmptyAttributes(userLink));
        userEntity.setPassword(EntityTranslator.getEmptyPassword(userLink));
        return userEntity;
    }

    public static UserEntityList toUserEntities(List<User> users, URI baseUri) {
        ArrayList<UserEntity> userEntities = new ArrayList<UserEntity>(users.size());
        for (User user : users) {
            userEntities.add(EntityTranslator.toUserEntity(user, LinkUriHelper.buildUserLink(baseUri, user.getName())));
        }
        return new UserEntityList(userEntities);
    }

    public static UserEntityList toMinimalUserEntities(List<String> usernames, URI baseUri) {
        ArrayList<UserEntity> userEntities = new ArrayList<UserEntity>(usernames.size());
        for (String username : usernames) {
            userEntities.add(UserEntity.newMinimalUserEntity(username, null, LinkUriHelper.buildUserLink(baseUri, username)));
        }
        return new UserEntityList(userEntities);
    }

    public static UserWithAttributes fromUserEntity(UserEntity userEntity) {
        if (userEntity == null) {
            return null;
        }
        UserTemplateWithAttributes user = new UserTemplateWithAttributes(userEntity.getName(), -1L);
        user.setFirstName(userEntity.getFirstName());
        user.setLastName(userEntity.getLastName());
        user.setDisplayName(userEntity.getDisplayName());
        user.setEmailAddress(userEntity.getEmail());
        user.setActive(userEntity.isActive() != null ? userEntity.isActive() : false);
        if (userEntity.getAttributes() != null) {
            for (MultiValuedAttributeEntity attributeEntity : userEntity.getAttributes()) {
                user.setAttribute(attributeEntity.getName(), (Set)Sets.newHashSet((Iterable)attributeEntity.getValues()));
            }
        }
        return user;
    }

    public static UserEntity toUserEntity(User user, Attributes attributes, Link userLink) {
        if (user == null) {
            return null;
        }
        Validate.notNull((Object)attributes);
        Validate.notNull((Object)userLink);
        UserEntity userEntity = EntityTranslator.toUserEntity(user, userLink);
        Link userAttributesLink = Link.self((URI)LinkUriHelper.buildEntityAttributeListUri(userLink.getHref()));
        userEntity.setAttributes(EntityTranslator.toMultiValuedAttributeEntityList(attributes, userAttributesLink));
        return userEntity;
    }

    public static GroupEntity toGroupEntity(Group group, URI baseURI) {
        return EntityTranslator.toGroupEntity(group, LinkUriHelper.buildGroupLink(baseURI, group.getName()));
    }

    public static GroupEntityList toGroupEntities(List<Group> groups, URI baseURI) {
        ArrayList<GroupEntity> groupEntities = new ArrayList<GroupEntity>(groups.size());
        for (Group group : groups) {
            groupEntities.add(EntityTranslator.toGroupEntity(group, baseURI));
        }
        return new GroupEntityList(groupEntities);
    }

    public static GroupEntityList toMinimalGroupEntities(List<String> groupNames, URI baseUri) {
        ArrayList<GroupEntity> groupEntities = new ArrayList<GroupEntity>(groupNames.size());
        for (String groupName : groupNames) {
            groupEntities.add(GroupEntity.newMinimalGroupEntity(groupName, null, baseUri));
        }
        return new GroupEntityList(groupEntities);
    }

    public static GroupEntity toGroupEntity(Group group, Link groupLink) {
        GroupEntity groupEntity = new GroupEntity(group.getName(), group.getDescription(), group.getType(), group.isActive(), groupLink);
        groupEntity.setAttributes(EntityTranslator.getEmptyAttributes(groupLink));
        return groupEntity;
    }

    public static GroupEntity toGroupEntity(Group group, Attributes attributes, Link groupLink) {
        GroupEntity groupEntity = EntityTranslator.toGroupEntity(group, groupLink);
        Link groupAttributesLink = Link.self((URI)LinkUriHelper.buildEntityAttributeListUri(groupLink.getHref()));
        groupEntity.setAttributes(EntityTranslator.toMultiValuedAttributeEntityList(attributes, groupAttributesLink));
        return groupEntity;
    }

    public static GroupTemplate toGroup(GroupEntity groupEntity) {
        GroupTemplate group = new GroupTemplate(groupEntity.getName());
        group.setDescription(groupEntity.getDescription());
        group.setType(groupEntity.getType());
        group.setActive(groupEntity.isActive());
        return group;
    }

    public static MultiValuedAttributeEntityList toMultiValuedAttributeEntityList(Attributes attributes, Link link) {
        if (attributes == null) {
            return null;
        }
        Validate.notNull((Object)link);
        Set keys = attributes.getKeys();
        ArrayList<MultiValuedAttributeEntity> attributeList = new ArrayList<MultiValuedAttributeEntity>(keys.size());
        for (String key : keys) {
            Link attributeLink = Link.self((URI)LinkUriHelper.buildEntityAttributeUri(link.getHref(), key));
            attributeList.add(new MultiValuedAttributeEntity(key, (Collection)attributes.getValues(key), attributeLink));
        }
        return new MultiValuedAttributeEntityList(attributeList, link);
    }

    public static Map<String, Set<String>> toAttributes(MultiValuedAttributeEntityList attributeEntityList) {
        HashMap<String, Set<String>> attributes = new HashMap<String, Set<String>>(attributeEntityList.size());
        for (MultiValuedAttributeEntity attributeEntity : attributeEntityList) {
            attributes.put(attributeEntity.getName(), new HashSet(attributeEntity.getValues()));
        }
        return attributes;
    }

    private static MultiValuedAttributeEntityList getEmptyAttributes(Link entityLink) {
        Validate.notNull((Object)entityLink);
        return new MultiValuedAttributeEntityList(Collections.emptyList(), Link.self((URI)LinkUriHelper.buildEntityAttributeListUri(entityLink.getHref())));
    }

    private static PasswordEntity getEmptyPassword(Link userLink) {
        Validate.notNull((Object)userLink);
        return new PasswordEntity(null, Link.edit((URI)LinkUriHelper.buildUserPasswordUri(userLink.getHref())));
    }
}

