/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource.usermanagement;

import com.atlassian.crowd.plugin.rest.entity.CookieConfigEntity;
import com.atlassian.crowd.plugin.rest.service.controller.CookieConfigController;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;

@Path(value="config/cookie")
@AnonymousAllowed
@Produces(value={"application/xml", "application/json"})
public class CookieConfigResource {
    private static final String CACHE_CONTROL_MAX_AGE_SYSTEM_PROPERTY = "crowd.cookie-config.http.cache-control.max-age";
    private static final CacheControl SEMISTATIC_CONFIG = CacheControl.valueOf((String)("max-age=" + System.getProperty("crowd.cookie-config.http.cache-control.max-age", "30") + " stale-while-revalidate=10"));
    private final CookieConfigController controller;

    public CookieConfigResource(CookieConfigController controller) {
        Validate.notNull((Object)controller);
        this.controller = controller;
    }

    @GET
    public Response getConfig() {
        return Response.ok((Object)new CookieConfigEntity(this.controller.getDomain(), this.controller.isSecureCookie(), this.controller.getName())).cacheControl(SEMISTATIC_CONFIG).build();
    }
}

