/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.service.resource.directory;

import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.plugin.rest.entity.AzureAdConnectionTestEntity;
import com.atlassian.crowd.plugin.rest.entity.CrowdConnectionTestEntity;
import com.atlassian.crowd.plugin.rest.entity.LdapConnectionTestEntity;
import com.atlassian.crowd.plugin.rest.entity.LdapSearchTestEntity;
import com.atlassian.crowd.plugin.rest.exception.DirectoryTestFailedException;
import com.atlassian.crowd.plugin.rest.exception.ValidationFailedException;
import com.atlassian.crowd.plugin.rest.service.controller.DirectoryController;
import com.atlassian.crowd.plugin.rest.util.SysAdminInterceptor;
import com.atlassian.plugins.rest.common.interceptor.InterceptorChain;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="directory")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@InterceptorChain(value={SysAdminInterceptor.class})
public class DirectoryResource {
    private final DirectoryController directoryController;

    public DirectoryResource(DirectoryController directoryController) {
        this.directoryController = directoryController;
    }

    @POST
    @Path(value="testldap")
    public Response testLdapConnection(LdapConnectionTestEntity connectionTestData) throws OperationFailedException, DirectoryTestFailedException, ValidationFailedException {
        this.directoryController.testLdapConnection(connectionTestData);
        return Response.noContent().build();
    }

    @POST
    @Path(value="testldap/{id}")
    public Response testLdapConnection(@PathParam(value="id") Long id, LdapConnectionTestEntity connectionTestData) throws DirectoryNotFoundException, OperationFailedException, DirectoryTestFailedException, ValidationFailedException {
        this.directoryController.testLdapConnection(connectionTestData, id);
        return Response.noContent().build();
    }

    @POST
    @Path(value="testcrowd")
    public Response testCrowdConnection(CrowdConnectionTestEntity connectionTestData) throws OperationFailedException, DirectoryTestFailedException, ValidationFailedException {
        this.directoryController.testCrowdConnection(connectionTestData);
        return Response.noContent().build();
    }

    @POST
    @Path(value="testcrowd/{id}")
    public Response testCrowdConnection(@PathParam(value="id") Long id, CrowdConnectionTestEntity connectionTestData) throws DirectoryNotFoundException, OperationFailedException, DirectoryTestFailedException, ValidationFailedException {
        this.directoryController.testCrowdConnection(connectionTestData, id);
        return Response.noContent().build();
    }

    @POST
    @Path(value="testazuread")
    public Response testAzureAdConnection(AzureAdConnectionTestEntity connectionTestData) throws OperationFailedException, DirectoryTestFailedException, ValidationFailedException {
        this.directoryController.testAzureAdConnection(connectionTestData);
        return Response.noContent().build();
    }

    @POST
    @Path(value="testazuread/{id}")
    public Response testAzureAdConnection(@PathParam(value="id") Long id, AzureAdConnectionTestEntity connectionTestData) throws OperationFailedException, DirectoryTestFailedException, DirectoryNotFoundException, ValidationFailedException {
        this.directoryController.testAzureAdConnection(connectionTestData, id);
        return Response.noContent().build();
    }

    @POST
    @Path(value="testsearch")
    public Response testSearch(LdapSearchTestEntity ldapConfiguration) throws OperationFailedException, DirectoryTestFailedException, ValidationFailedException {
        this.directoryController.testLdapSearch(ldapConfiguration);
        return Response.noContent().build();
    }

    @POST
    @Path(value="testsearch/{id}")
    public Response testSearch(LdapSearchTestEntity ldapConfiguration, @PathParam(value="id") Long id) throws OperationFailedException, DirectoryNotFoundException, DirectoryTestFailedException, ValidationFailedException {
        this.directoryController.testLdapSearch(ldapConfiguration, id);
        return Response.noContent().build();
    }
}

