/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.plugin.rest.entity;

import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.manager.application.ApplicationManagerException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="error")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ApplicationErrorEntity {
    @XmlElement(name="reason")
    private final ErrorReason reason;
    @XmlElement(name="message")
    private final String message;

    private ApplicationErrorEntity() {
        this.reason = null;
        this.message = null;
    }

    public ApplicationErrorEntity(ErrorReason reason, String message) {
        this.reason = reason;
        this.message = message;
    }

    public ErrorReason getReason() {
        return this.reason;
    }

    public String getMessage() {
        return this.message;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @XmlEnum
    public static enum ErrorReason {
        APPLICATION_NOT_FOUND,
        APPLICATION_MODIFICATION_FAILED,
        DIRECTORY_NOT_FOUND,
        ILLEGAL_ARGUMENT,
        INVALID_CREDENTIAL,
        UNSUPPORTED_OPERATION,
        OPERATION_FAILED;


        public static ErrorReason of(Exception e) {
            if (e instanceof ApplicationNotFoundException) {
                return APPLICATION_NOT_FOUND;
            }
            if (e instanceof ApplicationManagerException) {
                return APPLICATION_MODIFICATION_FAILED;
            }
            if (e instanceof DirectoryNotFoundException) {
                return DIRECTORY_NOT_FOUND;
            }
            if (e instanceof IllegalArgumentException) {
                return ILLEGAL_ARGUMENT;
            }
            if (e instanceof InvalidCredentialException) {
                return INVALID_CREDENTIAL;
            }
            if (e instanceof UnsupportedOperationException) {
                return UNSUPPORTED_OPERATION;
            }
            return OPERATION_FAILED;
        }
    }
}

