/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.loader;

import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.CachingDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.RemoteCrowdDirectoryInstanceLoader;
import com.atlassian.crowd.directory.loader.RemoteDirectoryInstanceFactoryUtil;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteCrowdDirectoryInstanceLoaderImpl
extends CachingDirectoryInstanceLoader
implements RemoteCrowdDirectoryInstanceLoader {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final InstanceFactory instanceFactory;

    public RemoteCrowdDirectoryInstanceLoaderImpl(InstanceFactory instanceFactory, EventPublisher eventPublisher) {
        super(eventPublisher);
        this.instanceFactory = (InstanceFactory)Preconditions.checkNotNull((Object)instanceFactory);
    }

    public RemoteCrowdDirectory getRawDirectory(Long id, String className, Map<String, String> directoryAttributes) throws DirectoryInstantiationException {
        return this.getNewDirectory(id, className, directoryAttributes);
    }

    public boolean canLoad(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return RemoteCrowdDirectory.class.isAssignableFrom(clazz);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private RemoteCrowdDirectory getNewDirectory(Long id, String className, Map<String, String> directoryAttributes) throws DirectoryInstantiationException {
        return (RemoteCrowdDirectory)RemoteDirectoryInstanceFactoryUtil.newRemoteDirectory(RemoteCrowdDirectory.class, (InstanceFactory)this.instanceFactory, (Long)id, (String)className, directoryAttributes);
    }

    protected RemoteDirectory getNewDirectory(Directory directory) throws DirectoryInstantiationException {
        return this.getNewDirectory(directory.getId(), directory.getImplementationClass(), directory.getAttributes());
    }
}

