/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.password.constraint;

import com.atlassian.crowd.directory.password.constraint.CharacterClassAnalysis;
import com.atlassian.crowd.embedded.api.PasswordConstraint;
import com.atlassian.crowd.embedded.api.ValidatePasswordRequest;
import com.atlassian.crowd.exception.InvalidCharacterClassConstraintException;
import java.util.Objects;
import java.util.stream.Stream;

public class CharacterClassConstraint
implements PasswordConstraint {
    private final Integer minimumLowercase;
    private final Integer minimumUppercase;
    private final Integer minimumDigits;
    private final Integer minimumSpecialCharacters;
    private final Integer minimumRulesMatched;

    private CharacterClassConstraint(Integer minimumLowercase, Integer minimumUppercase, Integer minimumDigits, Integer minimumSpecialCharacters, Integer minimumRulesMatched) throws InvalidCharacterClassConstraintException {
        this.minimumLowercase = minimumLowercase;
        this.minimumUppercase = minimumUppercase;
        this.minimumDigits = minimumDigits;
        this.minimumSpecialCharacters = minimumSpecialCharacters;
        long ruleCount = Stream.of(minimumLowercase, minimumUppercase, minimumDigits, minimumSpecialCharacters).filter(Objects::nonNull).count();
        if (minimumRulesMatched != null && (long)minimumRulesMatched.intValue() > ruleCount) {
            throw new InvalidCharacterClassConstraintException(String.format("Number of rules to be matched: {%d} is greater than total number of rules: {%d}", minimumRulesMatched, ruleCount));
        }
        this.minimumRulesMatched = minimumRulesMatched;
    }

    public boolean validate(ValidatePasswordRequest validatePasswordRequest) {
        String password = validatePasswordRequest.getPassword().getCredential();
        if (this.minimumRulesMatched == null) {
            return this.validateAllRules(password);
        }
        return this.validateUsingMinimumRulesMatched(password);
    }

    private boolean validateUsingMinimumRulesMatched(String password) {
        CharacterClassAnalysis characterClassAnalysis = new CharacterClassAnalysis(password);
        int rulesMatched = 0;
        if (this.minimumLowercase != null && characterClassAnalysis.getLowercase() >= this.minimumLowercase) {
            ++rulesMatched;
        }
        if (this.minimumUppercase != null && characterClassAnalysis.getUppercase() >= this.minimumUppercase) {
            ++rulesMatched;
        }
        if (this.minimumDigits != null && characterClassAnalysis.getDigits() >= this.minimumDigits) {
            ++rulesMatched;
        }
        if (this.minimumSpecialCharacters != null && characterClassAnalysis.getSpecialCharacters() >= this.minimumSpecialCharacters) {
            ++rulesMatched;
        }
        return rulesMatched >= this.minimumRulesMatched;
    }

    private boolean validateAllRules(String password) {
        CharacterClassAnalysis characterClassAnalysis = new CharacterClassAnalysis(password);
        return !(this.minimumLowercase != null && characterClassAnalysis.getLowercase() < this.minimumLowercase || this.minimumUppercase != null && characterClassAnalysis.getUppercase() < this.minimumUppercase || this.minimumDigits != null && characterClassAnalysis.getDigits() < this.minimumDigits || this.minimumSpecialCharacters != null && characterClassAnalysis.getSpecialCharacters() < this.minimumSpecialCharacters);
    }

    public static CharacterClassConstraintBuilder builder() {
        return new CharacterClassConstraintBuilder();
    }

    public static class CharacterClassConstraintBuilder {
        private Integer minimumLowercase;
        private Integer minimumUppercase;
        private Integer minimumDigits;
        private Integer minimumSpecialCharacters;
        private Integer minimumRulesMatched;

        public CharacterClassConstraintBuilder minimumLowercase(Integer minimumLowercase) {
            this.minimumLowercase = minimumLowercase;
            return this;
        }

        public CharacterClassConstraintBuilder minimumLowercase(String minimumLowercaseString) {
            this.minimumLowercase = this.intOrNull(minimumLowercaseString);
            return this;
        }

        public CharacterClassConstraintBuilder minimumUppercase(Integer minimumUppercase) {
            this.minimumUppercase = minimumUppercase;
            return this;
        }

        public CharacterClassConstraintBuilder minimumUppercase(String minimumUppercaseString) {
            this.minimumUppercase = this.intOrNull(minimumUppercaseString);
            return this;
        }

        public CharacterClassConstraintBuilder minimumDigits(Integer minimumDigits) {
            this.minimumDigits = minimumDigits;
            return this;
        }

        public CharacterClassConstraintBuilder minimumDigits(String minimumDigitsString) {
            this.minimumDigits = this.intOrNull(minimumDigitsString);
            return this;
        }

        public CharacterClassConstraintBuilder minimumSpecialCharacters(Integer minimumSpecialCharacters) {
            this.minimumSpecialCharacters = minimumSpecialCharacters;
            return this;
        }

        public CharacterClassConstraintBuilder minimumSpecialCharacters(String minimumSpecialCharactersString) {
            this.minimumSpecialCharacters = this.intOrNull(minimumSpecialCharactersString);
            return this;
        }

        public CharacterClassConstraintBuilder minimumRulesMatched(Integer minimumRulesMatched) {
            this.minimumRulesMatched = minimumRulesMatched;
            return this;
        }

        public CharacterClassConstraintBuilder minimumRulesMatched(String minimumRulesMatchedString) {
            this.minimumRulesMatched = this.intOrNull(minimumRulesMatchedString);
            return this;
        }

        public CharacterClassConstraint build() throws InvalidCharacterClassConstraintException {
            return new CharacterClassConstraint(this.minimumLowercase, this.minimumUppercase, this.minimumDigits, this.minimumSpecialCharacters, this.minimumRulesMatched);
        }

        private Integer intOrNull(String value) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception ex) {
                return null;
            }
        }
    }
}

