/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.model.audit;

import com.atlassian.crowd.audit.AuditLogAuthorType;
import com.atlassian.crowd.audit.AuditLogChangeset;
import com.atlassian.crowd.audit.AuditLogEntityType;
import com.atlassian.crowd.audit.AuditLogEventType;
import com.atlassian.crowd.model.audit.AuditLogEntryEntity;
import com.google.common.base.Strings;
import java.time.Instant;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class AuditLogChangesetEntity
implements AuditLogChangeset {
    private Long id;
    private Long timestamp;
    private AuditLogAuthorType authorType;
    private Long authorId;
    private String authorName = "";
    private AuditLogEventType eventType;
    private AuditLogEntityType entityType;
    private Long entityId;
    private String entityName = "";
    private String ipAddress = "";
    private String eventMessage = "";
    private Set<AuditLogEntryEntity> entries = new HashSet<AuditLogEntryEntity>();

    public AuditLogChangesetEntity() {
    }

    public AuditLogChangesetEntity(AuditLogChangeset changeset) {
        this.id = changeset.getId();
        this.timestamp = changeset.getTimestampInstant().toEpochMilli();
        this.authorType = changeset.getAuthorType();
        this.authorId = changeset.getAuthorId();
        this.authorName = Strings.nullToEmpty((String)changeset.getAuthorName());
        this.eventType = changeset.getEventType();
        this.entityType = changeset.getEntityType();
        this.entityId = changeset.getEntityId();
        this.entityName = Strings.nullToEmpty((String)changeset.getEntityName());
        this.ipAddress = Strings.nullToEmpty((String)changeset.getIpAddress());
        this.eventMessage = Strings.nullToEmpty((String)changeset.getEventMessage());
        changeset.getEntries().stream().map(AuditLogEntryEntity::new).forEach(auditLogEntry -> this.entries.add((AuditLogEntryEntity)auditLogEntry));
    }

    public Long getId() {
        return this.id;
    }

    public Instant getTimestampInstant() {
        return this.timestamp != null ? Instant.ofEpochMilli(this.timestamp) : null;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public AuditLogAuthorType getAuthorType() {
        return this.authorType;
    }

    public void setAuthorType(AuditLogAuthorType authorType) {
        this.authorType = authorType;
    }

    public Long getAuthorId() {
        return this.authorId;
    }

    public void setAuthorId(Long authorId) {
        this.authorId = authorId;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public void setAuthorName(String authorName) {
        this.authorName = Strings.nullToEmpty((String)authorName);
    }

    public AuditLogEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(AuditLogEventType eventType) {
        this.eventType = eventType;
    }

    public AuditLogEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(AuditLogEntityType entityType) {
        this.entityType = entityType;
    }

    public Long getEntityId() {
        return this.entityId;
    }

    public void setEntityId(Long entityId) {
        this.entityId = entityId;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = Strings.nullToEmpty((String)entityName);
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = Strings.nullToEmpty((String)ipAddress);
    }

    public String getEventMessage() {
        return this.eventMessage;
    }

    public void setEventMessage(String eventMessage) {
        this.eventMessage = Strings.nullToEmpty((String)eventMessage);
    }

    public Set<AuditLogEntryEntity> getEntries() {
        return this.entries;
    }

    public void setEntries(Set<AuditLogEntryEntity> auditLogEntries) {
        this.entries = auditLogEntries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuditLogChangesetEntity that = (AuditLogChangesetEntity)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getTimestamp(), that.getTimestamp()) && Objects.equals(this.getAuthorType(), that.getAuthorType()) && Objects.equals(this.getAuthorId(), that.getAuthorId()) && Objects.equals(this.getAuthorName(), that.getAuthorName()) && Objects.equals(this.getEventType(), that.getEventType()) && Objects.equals(this.getEntityType(), that.getEntityType()) && Objects.equals(this.getEntityId(), that.getEntityId()) && Objects.equals(this.getEntityName(), that.getEntityName()) && Objects.equals(this.getIpAddress(), that.getIpAddress()) && Objects.equals(this.getEventMessage(), that.getEventMessage()) && Objects.equals(this.getEntries(), that.getEntries());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getTimestamp(), this.getAuthorType(), this.getAuthorId(), this.getAuthorName(), this.getEventType(), this.getEntityType(), this.getEntityId(), this.getEntityName(), this.getIpAddress(), this.getEventMessage(), this.getEntries());
    }
}

