/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.dao.application;

import com.atlassian.crowd.dao.CriteriaFactory;
import com.atlassian.crowd.dao.alias.AliasDAO;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.dao.directory.DirectoryDAOHibernate;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.ObjectNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.hibernate.HQLQuery;
import com.atlassian.crowd.search.hibernate.HQLQueryTranslater;
import com.atlassian.crowd.search.hibernate.HibernateSearchResultsTransformer;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.persistence.hibernate.HibernateDao;
import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.hibernate3.HibernateCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDAOHibernate
extends HibernateDao
implements ApplicationDAO {
    private HQLQueryTranslater hqlQueryTranslater;
    private AliasDAO aliasDAO;
    private DirectoryDAOHibernate directoryDao;

    @Override
    public Class getPersistentClass() {
        return ApplicationImpl.class;
    }

    public ApplicationImpl findById(long id) throws ApplicationNotFoundException {
        try {
            return (ApplicationImpl)this.load(id);
        }
        catch (ObjectNotFoundException e) {
            throw new ApplicationNotFoundException(Long.valueOf(id));
        }
    }

    public ApplicationImpl findByName(final String name) throws ApplicationNotFoundException {
        Object result = this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return CriteriaFactory.createCriteria(session, ApplicationDAOHibernate.this.getPersistentClass()).add((Criterion)Restrictions.eq((String)"lowerName", (Object)IdentifierUtils.toLowerCase((String)name))).uniqueResult();
            }
        });
        if (result == null) {
            throw new ApplicationNotFoundException(name);
        }
        return (ApplicationImpl)result;
    }

    public ApplicationImpl add(Application application, PasswordCredential passwordCredential) {
        ApplicationImpl internalApplication = ApplicationImpl.newInstance((Application)application);
        internalApplication.setCredential(passwordCredential);
        internalApplication.setCreatedDateToNow();
        internalApplication.setUpdatedDateToNow();
        internalApplication.setAttribute("atlassian_sha1_applied", Boolean.TRUE.toString());
        internalApplication.validate();
        super.save(internalApplication);
        return internalApplication;
    }

    public ApplicationImpl update(Application application) throws ApplicationNotFoundException {
        ApplicationImpl internalApplication = this.findById(application.getId());
        internalApplication.updateDetailsFromApplication(application);
        internalApplication.setUpdatedDateToNow();
        internalApplication.validate();
        super.update(internalApplication);
        return internalApplication;
    }

    @Override
    public void updateCredential(Application application, PasswordCredential passwordCredential) throws ApplicationNotFoundException {
        if (!passwordCredential.isEncryptedCredential()) {
            throw new IllegalArgumentException("The application password needs to be encrypted before being updated");
        }
        ApplicationImpl internalApplication = this.findByName(application.getName());
        internalApplication.setCredential(passwordCredential);
        internalApplication.setAttribute("atlassian_sha1_applied", Boolean.TRUE.toString());
        internalApplication.setUpdatedDateToNow();
        super.update(internalApplication);
    }

    @Override
    public void remove(Application application) {
        this.aliasDAO.removeAliases(application);
        super.remove(application);
    }

    @Override
    public List<Application> search(final EntityQuery<Application> query) {
        if (query.getEntityDescriptor().getEntityType() != Entity.APPLICATION) {
            throw new IllegalArgumentException("ApplicationDAO can only evaluate EntityQueries for Entity.APPLICATION");
        }
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                HQLQuery hqlQuery = ApplicationDAOHibernate.this.hqlQueryTranslater.asHQL(query);
                Query hibernateQuery = session.createQuery(hqlQuery.toString()).setFirstResult(query.getStartIndex());
                if (query.getMaxResults() != -1) {
                    hibernateQuery.setMaxResults(query.getMaxResults());
                }
                ListIterator<Object> iterator = hqlQuery.getParameterValues().listIterator();
                while (iterator.hasNext()) {
                    Object value = iterator.next();
                    hibernateQuery.setParameter(iterator.previousIndex(), value);
                }
                return HibernateSearchResultsTransformer.transformResults(hibernateQuery.list());
            }
        });
    }

    @Override
    public void addDirectoryMapping(long applicationId, long directoryId, boolean allowAllToAuthenticate, OperationType ... operationTypes) throws DirectoryNotFoundException, ApplicationNotFoundException {
        ApplicationImpl application = this.findById(applicationId);
        DirectoryImpl directory = this.directoryDao.findById(directoryId);
        application.addDirectoryMapping((Directory)directory, allowAllToAuthenticate, operationTypes);
        application.setUpdatedDateToNow();
        super.update(application);
    }

    @Override
    public void addRemoteAddress(long applicationId, RemoteAddress remoteAddress) throws ApplicationNotFoundException {
        Validate.notNull((Object)remoteAddress);
        ApplicationImpl application = this.findById(applicationId);
        application.addRemoteAddress(remoteAddress.getAddress());
        application.setUpdatedDateToNow();
        super.update(application);
    }

    @Override
    public void removeRemoteAddress(long applicationId, RemoteAddress remoteAddress) throws ApplicationNotFoundException {
        Validate.notNull((Object)remoteAddress);
        ApplicationImpl application = this.findById(applicationId);
        application.removeRemoteAddress(remoteAddress.getAddress());
        super.update(application);
    }

    @Override
    public void removeDirectoryMapping(long applicationId, long directoryId) throws ApplicationNotFoundException {
        ApplicationImpl application = this.findById(applicationId);
        application.removeDirectoryMapping(directoryId);
        application.setUpdatedDateToNow();
        super.update(application);
    }

    @Override
    public void removeDirectoryMappings(final long directoryId) {
        List applications = this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("findApplicationsWithDirectoryMapping").setLong("directoryId", directoryId).list();
            }
        });
        for (ApplicationImpl application : applications) {
            application.removeDirectoryMapping(directoryId);
            application.setUpdatedDateToNow();
            super.update(application);
        }
    }

    @Override
    public void addGroupMapping(long applicationId, long directoryId, String groupName) throws ApplicationNotFoundException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)groupName));
        ApplicationImpl application = this.findById(applicationId);
        application.addGroupMapping(directoryId, groupName);
        super.update(application);
    }

    @Override
    public void removeGroupMapping(final long applicationId, final long directoryId, final String groupName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeGroupMappings").setLong("applicationId", applicationId).setLong("directoryId", directoryId).setString("groupName", groupName).executeUpdate();
            }
        });
    }

    @Override
    public void removeGroupMappings(final long directoryId, final String groupName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("removeAllGroupMappings").setLong("directoryId", directoryId).setString("groupName", groupName).executeUpdate();
            }
        });
    }

    @Override
    public void renameGroupMappings(final long directoryId, final String oldGroupName, final String newGroupName) {
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("renameGroupMappings").setLong("directoryId", directoryId).setString("oldGroupName", oldGroupName).setString("newGroupName", newGroupName).executeUpdate();
            }
        });
    }

    @Override
    public List<Application> findAuthorisedApplications(final long directoryId, final List<String> groupNames) {
        if (groupNames == null || groupNames.isEmpty()) {
            return this.getHibernateTemplate().executeFind(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException, SQLException {
                    return session.getNamedQuery("findAuthorisedApplicationsWithoutGroupNames").setLong("directoryId", directoryId).list();
                }
            });
        }
        return this.getHibernateTemplate().executeFind(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.getNamedQuery("findAuthorisedApplications").setLong("directoryId", directoryId).setParameterList("groupNames", (Collection)groupNames).list();
            }
        });
    }

    @Override
    public void updateDirectoryMapping(long applicationId, long directoryId, int position) throws ApplicationNotFoundException, DirectoryNotFoundException {
        ApplicationImpl application = this.findById(applicationId);
        List directoryMappings = application.getDirectoryMappings();
        DirectoryMapping directoryMapping = application.getDirectoryMapping(directoryId);
        if (directoryMapping == null) {
            throw new DirectoryNotFoundException(Long.valueOf(directoryId));
        }
        int currentIndex = directoryMappings.indexOf(directoryMapping);
        if (currentIndex >= 0 && position >= 0 && position < directoryMappings.size()) {
            DirectoryMapping directoryMappingToMove = (DirectoryMapping)directoryMappings.remove(currentIndex);
            directoryMappings.add(position, directoryMappingToMove);
            application.setUpdatedDateToNow();
            super.update(application);
        }
    }

    @Override
    public void updateDirectoryMapping(long applicationId, long directoryId, boolean allowAllToAuthenticate) throws ApplicationNotFoundException, DirectoryNotFoundException {
        ApplicationImpl application = this.findById(applicationId);
        DirectoryMapping directoryMapping = application.getDirectoryMapping(directoryId);
        if (directoryMapping == null) {
            throw new DirectoryNotFoundException(Long.valueOf(directoryId));
        }
        directoryMapping.setAllowAllToAuthenticate(allowAllToAuthenticate);
        application.setUpdatedDateToNow();
        super.update(application);
    }

    @Override
    public void updateDirectoryMapping(long applicationId, long directoryId, boolean allowAllToAuthenticate, Set<OperationType> operationTypes) throws ApplicationNotFoundException, DirectoryNotFoundException {
        ApplicationImpl application = this.findById(applicationId);
        DirectoryMapping directoryMapping = application.getDirectoryMapping(directoryId);
        if (directoryMapping == null) {
            throw new DirectoryNotFoundException(Long.valueOf(directoryId));
        }
        directoryMapping.setAllowAllToAuthenticate(allowAllToAuthenticate);
        directoryMapping.setAllowedOperations(operationTypes);
        application.setUpdatedDateToNow();
        super.update(application);
    }

    public void setHqlQueryTranslater(HQLQueryTranslater hqlQueryTranslater) {
        this.hqlQueryTranslater = hqlQueryTranslater;
    }

    public void setAliasDAO(AliasDAO aliasDAO) {
        this.aliasDAO = aliasDAO;
    }

    public void setDirectoryDao(DirectoryDAOHibernate directoryDao) {
        this.directoryDao = directoryDao;
    }
}

