/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.AbstractInternalDirectory;
import com.atlassian.crowd.directory.InternalDirectory;
import com.atlassian.crowd.directory.InternalDirectoryUtils;
import com.atlassian.crowd.directory.PasswordConstraintsLoader;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.embedded.spi.LocalServiceDeskUserFeatureControl;
import com.atlassian.crowd.embedded.spi.MembershipDao;
import com.atlassian.crowd.embedded.spi.ProductPermissionDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.util.BatchResult;
import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingDirectory
extends AbstractInternalDirectory {
    private static final Logger logger = LoggerFactory.getLogger(InternalDirectory.class);
    private final LocalServiceDeskUserFeatureControl localServiceDeskUserFeatureControl;

    public CachingDirectory(InternalDirectoryUtils internalDirectoryUtils, PasswordEncoderFactory passwordEncoderFactory, DirectoryDao directoryDao, UserDao userDao, GroupDao groupDao, MembershipDao membershipDao, ProductPermissionDao productPermissionDao, PasswordConstraintsLoader passwordConstraints, LocalServiceDeskUserFeatureControl localServiceDeskUserFeatureControl) {
        super(internalDirectoryUtils, passwordEncoderFactory, directoryDao, userDao, groupDao, membershipDao, productPermissionDao, passwordConstraints);
        this.localServiceDeskUserFeatureControl = localServiceDeskUserFeatureControl;
    }

    @Override
    public com.atlassian.crowd.model.user.User addUser(UserTemplate user, PasswordCredential credential) throws InvalidCredentialException, InvalidUserException, UserAlreadyExistsException, OperationFailedException {
        com.atlassian.crowd.model.user.User addedUser;
        this.internalDirectoryUtils.validateDirectoryForEntity((DirectoryEntity)user, this.directoryId);
        PasswordCredential encryptedCredential = credential;
        boolean storePasswordUpdateAttributes = false;
        if (this.isLocalServiceDeskUserManagementActive()) {
            com.atlassian.crowd.model.user.User elevatedUser;
            if (user.isLocalServiceDeskUser()) {
                if (credential != null && !credential.isEncryptedCredential()) {
                    this.internalDirectoryUtils.validateCredential((User)user, credential, this.getPasswordConstraints(), this.getValue("password_complexity_message"));
                    encryptedCredential = this.encryptedCredential(credential);
                }
                storePasswordUpdateAttributes = true;
                if (user.getExternalId() == null) {
                    user.setExternalId(InternalDirectory.generateUniqueIdentifier());
                }
            }
            if ((elevatedUser = this.handleAddUserLocalUserConflictsAndElevateLocalUserIfPossible(user)) != null) {
                return elevatedUser;
            }
        }
        try {
            addedUser = this.userDao.add((com.atlassian.crowd.model.user.User)user, encryptedCredential);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidUserException((User)user, e.getMessage(), (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
        if (storePasswordUpdateAttributes) {
            try {
                this.userDao.storeAttributes(addedUser, CachingDirectory.calculatePostPasswordUpdateAttributes());
            }
            catch (UserNotFoundException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        return addedUser;
    }

    public com.atlassian.crowd.model.user.User addOrUpdate(UserTemplate user, PasswordCredential credential) throws OperationFailedException, InvalidUserException, InvalidCredentialException {
        com.atlassian.crowd.model.user.User elevatedUser;
        this.internalDirectoryUtils.validateDirectoryForEntity((DirectoryEntity)user, this.directoryId);
        if (this.isLocalServiceDeskUserManagementActive() && (elevatedUser = this.handleAddUserLocalUserConflictsAndElevateLocalUserIfPossible(user)) != null) {
            return elevatedUser;
        }
        try {
            return this.userDao.addOrUpdate((com.atlassian.crowd.model.user.User)user, credential);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidUserException((User)user, e.getMessage(), (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public Group addLocalGroup(GroupTemplate group) throws InvalidGroupException, OperationFailedException {
        this.internalDirectoryUtils.validateDirectoryForEntity((DirectoryEntity)group, this.directoryId);
        this.internalDirectoryUtils.validateGroupName((Group)group, group.getName());
        try {
            return this.groupDao.addLocal((Group)group);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidGroupException((Group)group, e.getMessage(), (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new OperationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    public BatchResult<com.atlassian.crowd.model.user.User> addAllUsers(Set<UserTemplateWithCredentialAndAttributes> users) {
        for (UserTemplateWithCredentialAndAttributes user : users) {
            this.internalDirectoryUtils.validateDirectoryForEntity((DirectoryEntity)user, this.directoryId);
        }
        if (this.isLocalServiceDeskUserManagementActive()) {
            return this.addOrElevateAll(users);
        }
        return this.userDao.addAll(users);
    }

    @VisibleForTesting
    BatchResult<com.atlassian.crowd.model.user.User> addOrElevateAll(Set<UserTemplateWithCredentialAndAttributes> users) {
        BatchResult result = new BatchResult(users.size());
        HashSet<UserTemplateWithCredentialAndAttributes> usersStillToAdd = new HashSet<UserTemplateWithCredentialAndAttributes>();
        for (UserTemplateWithCredentialAndAttributes user : users) {
            try {
                com.atlassian.crowd.model.user.User elevatedUser = this.handleAddUserLocalUserConflictsAndElevateLocalUserIfPossible((UserTemplate)user);
                if (elevatedUser != null) {
                    result.addSuccess((Object)elevatedUser);
                    continue;
                }
                usersStillToAdd.add(user);
            }
            catch (InvalidUserException e) {
                logger.error("Could not elevate user user <" + user.getName() + ">: " + e.getMessage());
                result.addFailure((Object)user);
            }
        }
        if (!usersStillToAdd.isEmpty()) {
            BatchResult addAllBatchResult = this.userDao.addAll(users);
            result.addSuccesses((Collection)addAllBatchResult.getSuccessfulEntities());
            result.addFailures((Collection)addAllBatchResult.getFailedEntities());
        }
        return result;
    }

    public BatchResult<Group> addAllGroups(Set<GroupTemplate> groups) {
        for (GroupTemplate group : groups) {
            this.internalDirectoryUtils.validateDirectoryForEntity((DirectoryEntity)group, this.directoryId);
            this.internalDirectoryUtils.validateGroupName((Group)group, group.getName());
        }
        try {
            return this.groupDao.addAll(groups);
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public BatchResult<String> addAllUsersToGroup(Set<String> userNames, String groupName) throws GroupNotFoundException {
        Validate.notNull(userNames, (String)"userNames cannot be null", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)groupName, (String)"groupName cannot be null or empty", (Object[])new Object[0]);
        return this.membershipDao.addAllUsersToGroup(this.getDirectoryId(), userNames, groupName);
    }

    public com.atlassian.crowd.model.user.User updateUser(UserTemplate user) throws InvalidUserException, UserNotFoundException {
        this.internalDirectoryUtils.validateDirectoryForEntity((DirectoryEntity)user, this.directoryId);
        if (this.isLocalServiceDeskUserManagementActive()) {
            this.handleUpdateUserLocalUserConflicts(user);
        }
        try {
            return this.userDao.update((com.atlassian.crowd.model.user.User)user);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidUserException((User)user, e.getMessage(), (Throwable)e);
        }
    }

    @VisibleForTesting
    com.atlassian.crowd.model.user.User handleAddUserLocalUserConflictsAndElevateLocalUserIfPossible(UserTemplate user) throws InvalidUserException {
        if (user.isLocalServiceDeskUser()) {
            return null;
        }
        com.atlassian.crowd.model.user.User elevatedUser = this.findAndElevateLocalUserForRemoteUserToAdd(user);
        if (elevatedUser != null) {
            return elevatedUser;
        }
        this.checkAndResolveLocalUserUsernameConflict(user.getName());
        if (StringUtils.isNotEmpty((String)user.getExternalId())) {
            this.checkAndResolveLocalUserExternalIdConflict(user.getExternalId());
        }
        if (StringUtils.isNotEmpty((String)user.getEmailAddress())) {
            this.checkAndResolveLocalUserEmailConflicts(user.getEmailAddress());
        }
        return null;
    }

    @VisibleForTesting
    void handleUpdateUserLocalUserConflicts(UserTemplate user) throws UserNotFoundException {
        if (user.isLocalServiceDeskUser()) {
            return;
        }
        TimestampedUser existingUser = this.userDao.findByName(user.getDirectoryId(), user.getName());
        if (StringUtils.isNotEmpty((String)user.getExternalId()) && !StringUtils.equals((String)existingUser.getExternalId(), (String)user.getExternalId())) {
            this.checkAndResolveLocalUserExternalIdConflict(user.getExternalId());
        }
        if (StringUtils.isNotEmpty((String)user.getEmailAddress()) && !IdentifierUtils.equalsInLowerCase((String)existingUser.getEmailAddress(), (String)user.getEmailAddress())) {
            this.checkAndResolveLocalUserEmailConflicts(user.getEmailAddress());
        }
    }

    @VisibleForTesting
    void checkAndResolveLocalUserUsernameConflict(String name) {
        TimestampedUser userByName;
        try {
            userByName = this.findUserByName(name);
        }
        catch (UserNotFoundException e) {
            return;
        }
        if (userByName.isLocalServiceDeskUser()) {
            String vacantUsername = this.findVacantUsernameForLocalUser((com.atlassian.crowd.model.user.User)userByName);
            try {
                this.userDao.rename((com.atlassian.crowd.model.user.User)userByName, vacantUsername);
            }
            catch (UserAlreadyExistsException | UserNotFoundException e) {
                throw new ConcurrentModificationException("Unable to rename local user from " + userByName.getName() + " to " + vacantUsername, e);
            }
        }
    }

    @VisibleForTesting
    void checkAndResolveLocalUserExternalIdConflict(String externalId) {
        TimestampedUser userByExternalId;
        if (StringUtils.isEmpty((String)externalId)) {
            return;
        }
        try {
            userByExternalId = this.findUserByExternalId(externalId);
        }
        catch (UserNotFoundException e) {
            return;
        }
        if (userByExternalId.isLocalServiceDeskUser()) {
            try {
                UserTemplate userTemplate = new UserTemplate((com.atlassian.crowd.model.user.User)userByExternalId);
                userTemplate.setExternalId(InternalDirectory.generateUniqueIdentifier());
                this.userDao.update((com.atlassian.crowd.model.user.User)userTemplate);
            }
            catch (UserNotFoundException e) {
                logger.warn("Unable to update local user with conflicting externalId [ {} ]", (Object)userByExternalId.getName());
            }
        }
    }

    @VisibleForTesting
    void checkAndResolveLocalUserEmailConflicts(String emailAddress) {
        List localUsersWithConflictingEmail = this.findUsersByEmail(emailAddress).stream().filter(User::isLocalServiceDeskUser).filter(User::isActive).collect(Collectors.toList());
        for (com.atlassian.crowd.model.user.User localUser : localUsersWithConflictingEmail) {
            try {
                UserTemplate userTemplate = new UserTemplate(localUser);
                userTemplate.setActive(false);
                this.userDao.update((com.atlassian.crowd.model.user.User)userTemplate);
            }
            catch (UserNotFoundException e) {
                logger.warn("Unable to deactivate local user with conflicting email [ {} ]", (Object)localUser.getName());
            }
        }
    }

    @VisibleForTesting
    com.atlassian.crowd.model.user.User findAndElevateLocalUserForRemoteUserToAdd(UserTemplate userToAdd) throws InvalidUserException {
        if (userToAdd.isLocalServiceDeskUser()) {
            throw new IllegalArgumentException("User to add must not be local");
        }
        com.atlassian.crowd.model.user.User userToElevate = this.findUserToElevate(userToAdd.getEmailAddress());
        if (userToElevate == null) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)userToAdd.getExternalId())) {
            this.checkAndResolveLocalUserExternalIdConflict(userToAdd.getExternalId());
        }
        if (!StringUtils.equals((String)userToAdd.getName(), (String)userToElevate.getName())) {
            try {
                this.forceRenameUser(userToElevate, userToAdd.getName());
            }
            catch (UserNotFoundException e) {
                throw new ConcurrentModificationException("Unable to rename local user for the purpose of merging it with a new remote user to add", e);
            }
        }
        try {
            return this.userDao.update((com.atlassian.crowd.model.user.User)userToAdd);
        }
        catch (UserNotFoundException e) {
            throw new ConcurrentModificationException("Failed to update local user with remote user details", e);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidUserException((User)userToAdd, e.getMessage(), (Throwable)e);
        }
    }

    @VisibleForTesting
    com.atlassian.crowd.model.user.User findUserToElevate(String emailAddress) {
        if (StringUtils.isEmpty((String)emailAddress)) {
            return null;
        }
        Collection<com.atlassian.crowd.model.user.User> usersWithMatchingEmail = this.findUsersByEmail(emailAddress);
        if (usersWithMatchingEmail.isEmpty()) {
            return null;
        }
        if (usersWithMatchingEmail.size() > 1) {
            logger.warn("More than one local user found for email {}, unable to elevate");
            return null;
        }
        com.atlassian.crowd.model.user.User user = usersWithMatchingEmail.iterator().next();
        if (!user.isLocalServiceDeskUser()) {
            return null;
        }
        return user;
    }

    private boolean isLocalServiceDeskUserManagementActive() {
        return this.localServiceDeskUserFeatureControl.isLocalServiceDeskUserManagementActive();
    }
}

