/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.mapper;

import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.directory.ldap.mapper.ContextMapperWithCustomAttributes;
import com.atlassian.crowd.directory.ldap.mapper.NameAttributesPair;
import com.atlassian.crowd.directory.ldap.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.directory.ldap.mapper.entity.LDAPGroupAttributesMapper;
import com.atlassian.crowd.directory.ldap.name.CrowdLdapName;
import com.atlassian.crowd.directory.ldap.util.DNStandardiser;
import com.atlassian.crowd.model.group.GroupTemplateWithAttributes;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import java.util.List;
import java.util.Set;
import javax.naming.directory.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.ldap.NamingException;

public class GroupContextMapper
extends ContextMapperWithCustomAttributes<LDAPGroupWithAttributes> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final long directoryId;
    protected final GroupType groupType;
    protected final LDAPPropertiesMapper ldapPropertiesMapper;

    public GroupContextMapper(long directoryId, GroupType groupType, LDAPPropertiesMapper ldapPropertiesMapper, List<AttributeMapper> customAttributeMappers) {
        super(customAttributeMappers);
        this.directoryId = directoryId;
        this.groupType = groupType;
        this.ldapPropertiesMapper = ldapPropertiesMapper;
    }

    @Override
    protected Set<String> getCoreRequiredLdapAttributes() {
        return this.getAttributesMapper().getRequiredLdapAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LDAPGroupWithAttributes mapFromContext(NameAttributesPair nameAttributesPair) throws NamingException {
        GroupTemplateWithAttributes groupTemplate;
        Attributes attributes = nameAttributesPair.getAttributes();
        LDAPGroupAttributesMapper mapper = this.getAttributesMapper();
        MDC.put((String)"crowd.ldap.context", (String)nameAttributesPair.getName().toString());
        try {
            groupTemplate = mapper.mapGroupFromAttributes(attributes);
        }
        finally {
            MDC.remove((String)"crowd.ldap.context");
        }
        for (AttributeMapper attributeMapper : this.customAttributeMappers) {
            try {
                groupTemplate.setAttribute(attributeMapper.getKey(), attributeMapper.getValues(nameAttributesPair));
            }
            catch (Exception e) {
                this.logger.error("Failed to map attribute <" + attributeMapper.getKey() + "> from context with DN <" + nameAttributesPair.getName().toString() + ">", (Throwable)e);
            }
        }
        CrowdLdapName groupName = DNStandardiser.ensureNameIsStandardised(nameAttributesPair.getName(), !this.ldapPropertiesMapper.isRelaxedDnStandardisation());
        LDAPGroupWithAttributes group = new LDAPGroupWithAttributes(groupName, groupTemplate);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Created group <" + String.valueOf(group) + "> from DN <" + String.valueOf(nameAttributesPair.getName()) + ">");
        }
        return group;
    }

    protected LDAPGroupAttributesMapper getAttributesMapper() {
        return new LDAPGroupAttributesMapper(this.directoryId, this.groupType, this.ldapPropertiesMapper);
    }
}

