/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.synchronisation.cache;

import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.RFC4519DirectoryMembershipsIterable;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.cache.UsnChangedCacheRefresherIncSyncException;
import com.atlassian.crowd.directory.synchronisation.CacheSynchronisationResult;
import com.atlassian.crowd.directory.synchronisation.PartialSynchronisationResult;
import com.atlassian.crowd.directory.synchronisation.cache.AbstractCacheRefresher;
import com.atlassian.crowd.directory.synchronisation.cache.CacheRefresher;
import com.atlassian.crowd.directory.synchronisation.cache.DirectoryCache;
import com.atlassian.crowd.directory.synchronisation.cache.LDAPEntityNameMap;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.DirectoryEntities;
import com.atlassian.crowd.model.Tombstone;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.fugue.Pair;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsnChangedCacheRefresher
extends AbstractCacheRefresher<LDAPGroupWithAttributes>
implements CacheRefresher {
    private static final Logger log = LoggerFactory.getLogger(UsnChangedCacheRefresher.class);
    private static final long UNINITIALISED = -1L;
    public static final String PROPERTY_USE_LEGACY_AD_INCREMENTAL_SYNC = "crowd.use.legacy.ad.incremental.sync";
    private final MicrosoftActiveDirectory activeDirectory;
    final LDAPEntityNameMap<LDAPUserWithAttributes> userMap = new LDAPEntityNameMap();
    private final LDAPEntityNameMap<LDAPGroupWithAttributes> groupMap = new LDAPEntityNameMap();
    private Future<List<LDAPUserWithAttributes>> userListFuture;
    private Future<List<LDAPGroupWithAttributes>> groupListFuture;
    private Set<String> groupsDnsToUpdate = new HashSet<String>();
    private Set<String> primaryGroupSids = new HashSet<String>();
    private final boolean useLegacyADIncrementalSync = Boolean.valueOf(System.getProperty("crowd.use.legacy.ad.incremental.sync", "false"));

    public UsnChangedCacheRefresher(MicrosoftActiveDirectory activeDirectory) {
        super((RemoteDirectory)activeDirectory);
        this.activeDirectory = activeDirectory;
    }

    public CacheSynchronisationResult synchroniseChanges(DirectoryCache directoryCache, @Nullable String highestCommittedUsn) throws OperationFailedException {
        if (!this.isIncrementalSyncEnabled()) {
            return CacheSynchronisationResult.FAILURE;
        }
        long lastUsnParsed = Optional.ofNullable(Strings.emptyToNull((String)highestCommittedUsn)).map(Long::parseLong).orElse(-1L);
        if (lastUsnParsed == -1L) {
            log.info("Synchronisation token not present, full sync of directory [{}] is necessary before incremental sync is possible.", (Object)this.activeDirectory.getDirectoryId());
            return CacheSynchronisationResult.FAILURE;
        }
        long currentHighestCommittedUSN = this.activeDirectory.fetchHighestCommittedUSN();
        this.synchroniseUserChanges(directoryCache, lastUsnParsed);
        this.synchroniseGroupChanges(directoryCache, lastUsnParsed);
        return new CacheSynchronisationResult(true, String.valueOf(currentHighestCommittedUSN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheSynchronisationResult synchroniseAll(DirectoryCache directoryCache) throws OperationFailedException {
        ExecutorService queryExecutor = Executors.newFixedThreadPool(3, ThreadFactories.namedThreadFactory((String)"CrowdUsnChangedCacheRefresher"));
        try {
            this.userListFuture = queryExecutor.submit(() -> {
                long start = System.currentTimeMillis();
                log.debug("loading remote users");
                List ldapUsers = this.isUserAttributeSynchronisationEnabled() ? this.activeDirectory.searchUsers(QueryBuilder.queryFor(UserWithAttributes.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1)) : this.activeDirectory.searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
                log.info("found [ {} ] remote users in [ {}ms ]", (Object)ldapUsers.size(), (Object)(System.currentTimeMillis() - start));
                return ldapUsers;
            });
            this.groupListFuture = queryExecutor.submit(() -> {
                long start = System.currentTimeMillis();
                log.debug("loading remote groups");
                List ldapGroups = this.isGroupAttributeSynchronisationEnabled() ? this.activeDirectory.searchGroups(QueryBuilder.queryFor(GroupWithAttributes.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1)) : this.activeDirectory.searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1));
                log.info("found [ " + ldapGroups.size() + " ] remote groups in [ " + (System.currentTimeMillis() - start) + "ms ]");
                return ldapGroups;
            });
            super.synchroniseAll(directoryCache);
            CacheSynchronisationResult cacheSynchronisationResult = new CacheSynchronisationResult(true, String.valueOf(this.activeDirectory.fetchHighestCommittedUSN()));
            return cacheSynchronisationResult;
        }
        finally {
            queryExecutor.shutdown();
            this.userListFuture = null;
            this.groupListFuture = null;
        }
    }

    protected PartialSynchronisationResult<? extends UserWithAttributes> synchroniseAllUsers(DirectoryCache directoryCache) throws OperationFailedException {
        Date syncStartDate = new Date();
        try {
            List<LDAPUserWithAttributes> ldapUsers = this.userListFuture.get();
            this.userMap.putAll(ldapUsers);
            directoryCache.deleteCachedUsersNotIn(ldapUsers, syncStartDate);
            directoryCache.addOrUpdateCachedUsers(ldapUsers, syncStartDate);
            return new PartialSynchronisationResult(ldapUsers);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException("background query interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    protected PartialSynchronisationResult<LDAPGroupWithAttributes> synchroniseAllGroups(DirectoryCache directoryCache) throws OperationFailedException {
        Date syncStartDate = new Date();
        try {
            List<LDAPGroupWithAttributes> ldapGroups = this.groupListFuture.get();
            ldapGroups = Collections.unmodifiableList(DirectoryEntities.filterOutDuplicates(ldapGroups));
            this.groupMap.putAll(ldapGroups);
            directoryCache.deleteCachedGroupsNotIn(GroupType.GROUP, ldapGroups, syncStartDate);
            directoryCache.addOrUpdateCachedGroups(ldapGroups, syncStartDate);
            return new PartialSynchronisationResult(ldapGroups);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException("background query interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private void synchroniseUserChangesUsn(DirectoryCache directoryCache, long highestCommittedUsn) throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug("loading changed remote users");
        List<LDAPUserWithAttributes> updatedUsers = this.activeDirectory.findAddedOrUpdatedUsersSince(highestCommittedUsn);
        List<Tombstone> tombstones = this.activeDirectory.findUserTombstonesSince(highestCommittedUsn);
        this.userMap.putAll(updatedUsers);
        log.info("found [ {} ] changed, [ {} ] deleted remote users in [ {}ms ]", new Object[]{updatedUsers.size(), tombstones.size(), System.currentTimeMillis() - start});
        ImmutableSet tombstonesGuids = ImmutableSet.copyOf((Iterable)Iterables.transform(tombstones, Tombstone::getObjectGUID));
        directoryCache.deleteCachedUsersByGuid((Set)tombstonesGuids);
        this.userMap.removeAllByGuid((Collection<String>)tombstonesGuids);
        directoryCache.addOrUpdateCachedUsers(updatedUsers, null);
    }

    private Pair<? extends Set<String>, ? extends Set<String>> validateAndReturnGuidsToAddAndDelete(DirectoryCache directoryCache) throws OperationFailedException {
        if (!this.activeDirectory.isExternalIdConfigured()) {
            throw new UsnChangedCacheRefresherIncSyncException("externalId attribute is not configured in directory.");
        }
        log.debug("loading changed users");
        ImmutableSet guidsInCache = ImmutableSet.copyOf((Collection)directoryCache.getAllUserGuids());
        if ((long)guidsInCache.size() != directoryCache.getUserCount()) {
            throw new UsnChangedCacheRefresherIncSyncException("Cache returned different number of guids and users (possible reason is overlapping guids in cache, most likely null/empty values).");
        }
        if (guidsInCache.contains("")) {
            throw new UsnChangedCacheRefresherIncSyncException("Empty guids returned from cache. Falling back to a full sync in order to populate the guids");
        }
        Set<String> guidsInAD = this.activeDirectory.findAllUserGuids();
        log.info("Found [ {} ] user GUIDs in cache, [ {} ] user GUIDs in remote directory", (Object)guidsInCache.size(), (Object)guidsInAD.size());
        if (guidsInAD.contains("")) {
            throw new UsnChangedCacheRefresherIncSyncException("Empty guids returned from AD. Possible reasons are externalId attribute value in directory configuration or AD server configuration.");
        }
        return Pair.pair((Object)Sets.difference(guidsInAD, (Set)guidsInCache), (Object)Sets.difference((Set)guidsInCache, guidsInAD));
    }

    private void synchroniseUserChangesGuid(DirectoryCache directoryCache, Long highestCommittedUsn) throws OperationFailedException {
        long start = System.currentTimeMillis();
        Pair<? extends Set<String>, ? extends Set<String>> guidsToAddAndRemove = this.validateAndReturnGuidsToAddAndDelete(directoryCache);
        Set guidsToAdd = (Set)guidsToAddAndRemove.left();
        Set guidsToRemove = (Set)guidsToAddAndRemove.right();
        ImmutableMap.Builder usersToAddByGuidBuilder = ImmutableMap.builder();
        ImmutableList.Builder usersToUpdateBuilder = ImmutableList.builder();
        for (LDAPUserWithAttributes user : this.activeDirectory.findAddedOrUpdatedUsersSince(highestCommittedUsn)) {
            String externalId = user.getExternalId();
            if (StringUtils.isEmpty((CharSequence)externalId)) {
                throw new UsnChangedCacheRefresherIncSyncException("A null or empty guid retrieved from AD.");
            }
            if (guidsToAdd.contains(externalId)) {
                usersToAddByGuidBuilder.put((Object)externalId, (Object)user);
                continue;
            }
            usersToUpdateBuilder.add((Object)user);
        }
        ImmutableMap usersToAddByGuid = usersToAddByGuidBuilder.build();
        ImmutableList usersToUpdate = usersToUpdateBuilder.build();
        log.info("scanned and compared [ {} ] users to delete, [ {} ] users to add, [ {} ] users to update in DB cache in [ {}ms ]", new Object[]{guidsToRemove.size(), guidsToAdd.size(), usersToUpdate.size(), System.currentTimeMillis() - start});
        directoryCache.deleteCachedUsersByGuid(guidsToRemove);
        this.userMap.removeAllByGuid(guidsToRemove);
        directoryCache.addOrUpdateCachedUsers((Collection)usersToUpdate, null);
        this.userMap.putAll((Collection<LDAPUserWithAttributes>)usersToUpdate);
        List newUsers = guidsToAdd.stream().map(this.getGuidToUserFunction((Map<String, LDAPUserWithAttributes>)usersToAddByGuid)).collect(Collectors.toList());
        directoryCache.addOrUpdateCachedUsers(newUsers, null);
        this.userMap.putAll(newUsers);
        for (LDAPUserWithAttributes newUser : newUsers) {
            Set<String> groups = newUser.getValues("memberOf");
            if (groups != null && groups.size() > 0) {
                this.groupsDnsToUpdate.addAll(groups);
            }
            if (!this.activeDirectory.getLdapPropertiesMapper().isPrimaryGroupSupported()) continue;
            Optional<String> primaryGroupSidOrEmpty = this.activeDirectory.getPrimaryGroupSIDOfUser(newUser);
            primaryGroupSidOrEmpty.ifPresent(s -> this.primaryGroupSids.add((String)s));
        }
    }

    void synchroniseUserChanges(DirectoryCache directoryCache, Long highestCommittedUsn) throws OperationFailedException {
        if (this.useLegacyADIncrementalSync) {
            this.synchroniseUserChangesUsn(directoryCache, highestCommittedUsn);
        } else {
            this.synchroniseUserChangesGuid(directoryCache, highestCommittedUsn);
        }
    }

    private void synchroniseGroupChanges(DirectoryCache directoryCache, long highestCommittedUsn) throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug("loading changed remote groups");
        List<LDAPGroupWithAttributes> addedOrUpdatedGroupsSince = this.activeDirectory.findAddedOrUpdatedGroupsSince(highestCommittedUsn);
        ArrayList<LDAPGroupWithAttributes> updatedGroups = new ArrayList<LDAPGroupWithAttributes>(DirectoryEntities.filterOutDuplicates(addedOrUpdatedGroupsSince));
        HashSet<LDAPGroupWithAttributes> groupsToUpdate = new HashSet<LDAPGroupWithAttributes>(this.activeDirectory.searchGroupsByDns(this.groupsDnsToUpdate));
        groupsToUpdate.addAll(this.activeDirectory.searchGroupsBySids(this.primaryGroupSids));
        groupsToUpdate.removeAll(addedOrUpdatedGroupsSince);
        updatedGroups.addAll(groupsToUpdate);
        List<Tombstone> tombstones = this.activeDirectory.findGroupTombstonesSince(highestCommittedUsn);
        log.info("found [ {} ] changed remote groups in [ {}ms ]", (Object)(updatedGroups.size() + tombstones.size()), (Object)(System.currentTimeMillis() - start));
        this.groupMap.putAll(updatedGroups);
        directoryCache.addOrUpdateCachedGroups(updatedGroups, null);
        this.synchroniseMemberships(updatedGroups, directoryCache);
        start = System.currentTimeMillis();
        directoryCache.deleteCachedGroupsByGuids(tombstones.stream().map(Tombstone::getObjectGUID).collect(Collectors.toSet()));
        log.info("Deleted [ {} ] groups for in DB cache in [ {}ms ]", (Object)tombstones.size(), (Object)(System.currentTimeMillis() - start));
    }

    Iterable<Membership> getMemberships(Collection<LDAPGroupWithAttributes> groupsToInclude) throws OperationFailedException {
        try {
            Map<LdapName, String> users = this.userMap.toLdapNameKeyedMap();
            Map<LdapName, String> groups = this.groupMap.toLdapNameKeyedMap();
            return new RFC4519DirectoryMembershipsIterable(this.activeDirectory, groupsToInclude, users, groups);
        }
        catch (InvalidNameException e) {
            throw new OperationFailedException("Failed to get directory memberships due to invalid DN", (Throwable)e);
        }
    }

    private Function<String, LDAPUserWithAttributes> getGuidToUserFunction(Map<String, LDAPUserWithAttributes> userCache) {
        return new GuidToUserFunction(this.activeDirectory, userCache);
    }

    static class GuidToUserFunction
    implements Function<String, LDAPUserWithAttributes> {
        private final MicrosoftActiveDirectory activeDirectory;
        private final Map<String, LDAPUserWithAttributes> userCache;

        GuidToUserFunction(MicrosoftActiveDirectory activeDirectory, Map<String, LDAPUserWithAttributes> userCache) {
            this.activeDirectory = activeDirectory;
            this.userCache = userCache;
        }

        @Override
        public LDAPUserWithAttributes apply(String externalId) {
            try {
                LDAPUserWithAttributes userFromCache = this.userCache.get(externalId);
                if (userFromCache != null) {
                    return userFromCache;
                }
                return this.activeDirectory.findUserByExternalId(externalId);
            }
            catch (UserNotFoundException e) {
                log.warn("User with objectGUID '{}' not found in ActiveDirectory", (Object)externalId);
            }
            catch (OperationFailedException e) {
                log.warn("Failed to fetch user by objectGUID '{}' from ActiveDirectory", (Object)externalId, (Object)e);
            }
            throw new UsnChangedCacheRefresherIncSyncException("Problems while looking up users by objectGUID in ActiveDirectory detected, falling back to a full sync.");
        }
    }
}

