/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap;

import com.atlassian.crowd.directory.ldap.mapper.ContextMapperWithRequiredAttributes;
import java.util.List;
import java.util.Set;
import javax.naming.Name;
import javax.naming.directory.Attributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapName;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.NameClassPairCallbackHandler;

public class LdapTemplateWithClassLoaderWrapper {
    private final LdapTemplate template;

    public LdapTemplateWithClassLoaderWrapper(LdapTemplate template) {
        this.template = template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T invokeWithContextClassLoader(CallableWithoutCheckedException<T> runnable) {
        Thread current = Thread.currentThread();
        ClassLoader orig = current.getContextClassLoader();
        try {
            ClassLoader classLoaderForThisClass = LdapTemplateWithClassLoaderWrapper.class.getClassLoader();
            current.setContextClassLoader(classLoaderForThisClass);
            T t = runnable.call();
            return t;
        }
        finally {
            current.setContextClassLoader(orig);
        }
    }

    public List search(final Name base, final String filter, final SearchControls controls, final ContextMapper mapper) {
        return LdapTemplateWithClassLoaderWrapper.invokeWithContextClassLoader(new CallableWithoutCheckedException<List>(){

            @Override
            public List call() {
                return LdapTemplateWithClassLoaderWrapper.this.template.search(base, filter, controls, mapper);
            }
        });
    }

    public List search(final Name base, final String filter, final SearchControls controls, final ContextMapper mapper, final DirContextProcessor processor) {
        return LdapTemplateWithClassLoaderWrapper.invokeWithContextClassLoader(new CallableWithoutCheckedException<List>(){

            @Override
            public List call() {
                return LdapTemplateWithClassLoaderWrapper.this.template.search(base, filter, controls, mapper, processor);
            }
        });
    }

    public Object lookup(final Name dn) {
        return LdapTemplateWithClassLoaderWrapper.invokeWithContextClassLoader(new CallableWithoutCheckedException<Object>(){

            @Override
            public Object call() {
                return LdapTemplateWithClassLoaderWrapper.this.template.lookup(dn);
            }
        });
    }

    public void search(final Name base, final String filter, final SearchControls controls, final NameClassPairCallbackHandler handler, final DirContextProcessor processor) {
        LdapTemplateWithClassLoaderWrapper.invokeWithContextClassLoader(new CallableWithoutCheckedException<Void>(){

            @Override
            public Void call() {
                LdapTemplateWithClassLoaderWrapper.this.template.search(base, filter, controls, handler, processor);
                return null;
            }
        });
    }

    public void unbind(final Name dn) {
        LdapTemplateWithClassLoaderWrapper.invokeWithContextClassLoader(new CallableWithoutCheckedException<Void>(){

            @Override
            public Void call() {
                LdapTemplateWithClassLoaderWrapper.this.template.unbind(dn);
                return null;
            }
        });
    }

    public void bind(final Name dn, final Object obj, final Attributes attributes) {
        LdapTemplateWithClassLoaderWrapper.invokeWithContextClassLoader(new CallableWithoutCheckedException<Void>(){

            @Override
            public Void call() {
                LdapTemplateWithClassLoaderWrapper.this.template.bind(dn, obj, attributes);
                return null;
            }
        });
    }

    public void modifyAttributes(final Name dn, final ModificationItem[] mods) {
        LdapTemplateWithClassLoaderWrapper.invokeWithContextClassLoader(new CallableWithoutCheckedException<Void>(){

            @Override
            public Void call() {
                LdapTemplateWithClassLoaderWrapper.this.template.modifyAttributes(dn, mods);
                return null;
            }
        });
    }

    public void lookup(final LdapName dn, final String[] attributes, final AttributesMapper mapper) {
        LdapTemplateWithClassLoaderWrapper.invokeWithContextClassLoader(new CallableWithoutCheckedException<Void>(){

            @Override
            public Void call() {
                LdapTemplateWithClassLoaderWrapper.this.template.lookup((Name)dn, attributes, mapper);
                return null;
            }
        });
    }

    public <T> T lookup(final LdapName dn, final ContextMapperWithRequiredAttributes<T> mapper) {
        Set<String> attrSet = mapper.getRequiredLdapAttributes();
        final String[] attributes = attrSet.toArray(new String[attrSet.size()]);
        return LdapTemplateWithClassLoaderWrapper.invokeWithContextClassLoader(new CallableWithoutCheckedException<T>(){

            @Override
            public T call() {
                return LdapTemplateWithClassLoaderWrapper.this.template.lookup((Name)dn, attributes, (ContextMapper)mapper);
            }
        });
    }

    public void setIgnorePartialResultException(boolean ignore) {
        this.template.setIgnorePartialResultException(ignore);
    }

    static interface CallableWithoutCheckedException<T> {
        public T call();
    }
}

