/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.cache.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialSet<E>
implements Serializable {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Set<E> set = new LinkedHashSet();
    private boolean complete;

    public PartialSet(E singleEntity) {
        this.set.add(singleEntity);
        this.complete = false;
    }

    public PartialSet(Collection<E> entities, boolean complete) {
        this.set.addAll(entities);
        this.complete = complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> asList() {
        try {
            this.readWriteLock.readLock().lock();
            List<E> list = Collections.unmodifiableList(new ArrayList<E>(this.set));
            return list;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Set<E> getUnderlyingSet() {
        return Collections.unmodifiableSet(this.set);
    }

    public boolean isComplete() {
        return this.complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(E entity) {
        try {
            this.readWriteLock.readLock().lock();
            boolean bl = this.set.contains(entity);
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(E entity) {
        try {
            this.readWriteLock.writeLock().lock();
            this.set.add(entity);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(E entity) {
        if (!this.contains(entity)) {
            return false;
        }
        try {
            this.readWriteLock.writeLock().lock();
            boolean bl = this.set.remove(entity);
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        try {
            this.readWriteLock.writeLock().lock();
            this.set.clear();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

