/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.RFC4519Directory;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventPublisher;
import javax.naming.directory.Attributes;
import org.apache.commons.lang.StringUtils;

public class OpenLDAP
extends RFC4519Directory {
    private final PasswordEncoderFactory passwordEncoderFactory;

    public OpenLDAP(LDAPQueryTranslater ldapQueryTranslater, EventPublisher eventPublisher, InstanceFactory instanceFactory, PasswordEncoderFactory passwordEncoderFactory) {
        super(ldapQueryTranslater, eventPublisher, instanceFactory);
        this.passwordEncoderFactory = passwordEncoderFactory;
    }

    public static String getStaticDirectoryType() {
        return "OpenLDAP";
    }

    public String getDescriptiveName() {
        return OpenLDAP.getStaticDirectoryType();
    }

    protected String encodePassword(String unencodedPassword) {
        if (unencodedPassword == null) {
            return null;
        }
        String encryptionAlgorithm = this.ldapPropertiesMapper.getUserEncryptionMethod();
        if (!StringUtils.isBlank((String)encryptionAlgorithm)) {
            PasswordEncoder passwordEncoder = this.passwordEncoderFactory.getLdapEncoder(encryptionAlgorithm);
            return passwordEncoder.encodePassword(unencodedPassword, null);
        }
        return unencodedPassword;
    }

    protected void getNewUserDirectorySpecificAttributes(User user, Attributes attributes) {
        this.addDefaultSnToUserAttributes(attributes, user.getName());
    }
}

