/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.integration.springsecurity.DynamicProviderManager;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;

public class DynamicProviderManagerImpl
extends ProviderManager
implements DynamicProviderManager {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        this.readWriteLock.readLock().lock();
        try {
            Authentication authentication2 = super.authenticate(authentication);
            return authentication2;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public void addProvider(AuthenticationProvider provider) {
        this.readWriteLock.writeLock().lock();
        try {
            this.getProviders().add(provider);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public boolean removeProvider(AuthenticationProvider provider) {
        this.readWriteLock.writeLock().lock();
        try {
            boolean bl = this.getProviders().remove(provider);
            return bl;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

