/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.springsecurity.CrowdAuthenticationProvider;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOTokenInvalidException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsService;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.service.client.CrowdClient;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class RemoteCrowdAuthenticationProvider
extends CrowdAuthenticationProvider {
    protected final CrowdClient authenticationManager;
    protected final CrowdHttpAuthenticator httpAuthenticator;
    protected final CrowdUserDetailsService userDetailsService;

    public RemoteCrowdAuthenticationProvider(CrowdClient authenticationManager, CrowdHttpAuthenticator httpAuthenticator, CrowdUserDetailsService userDetailsService) {
        this.authenticationManager = authenticationManager;
        this.httpAuthenticator = httpAuthenticator;
        this.userDetailsService = userDetailsService;
    }

    @Override
    protected boolean isAuthenticated(String token, List<ValidationFactor> validationFactors) throws OperationFailedException, InvalidAuthenticationException, ApplicationPermissionException {
        try {
            this.authenticationManager.validateSSOAuthentication(token, validationFactors);
            return true;
        }
        catch (InvalidTokenException e) {
            return false;
        }
    }

    @Override
    protected String authenticate(String username, String password, List<ValidationFactor> validationFactors) throws InactiveAccountException, ExpiredCredentialException, ApplicationPermissionException, InvalidAuthenticationException, OperationFailedException, ApplicationAccessDeniedException {
        UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext(username, PasswordCredential.unencrypted((String)password), validationFactors.toArray(new ValidationFactor[validationFactors.size()]), null);
        return this.authenticationManager.authenticateSSOUser(userAuthenticationContext);
    }

    @Override
    protected CrowdUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.userDetailsService.loadUserByUsername(username);
    }

    @Override
    protected CrowdUserDetails loadUserByToken(String token) throws CrowdSSOTokenInvalidException, DataAccessException {
        return this.userDetailsService.loadUserByToken(token);
    }
}

