/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.cache;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.service.cache.BasicCache;
import com.atlassian.crowd.util.Assert;
import com.atlassian.crowd.util.SOAPPrincipalHelper;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheImpl
implements BasicCache {
    private static final Logger logger = Logger.getLogger(CacheImpl.class);
    private final CacheManager ehCacheManager;
    private static final String USER_CACHE = "com.atlassian.crowd.integration-user";
    private static final String USER_WITH_ATTRIBUTE_CACHE = "com.atlassian.crowd.integration-user-with-attributes";
    private static final String USERNAMES_CACHE = "com.atlassian.crowd.integration-usernames";
    private static final String USERNAME_CASE_CACHE = "com.atlassian.crowd.integration-username-case";
    private static final String GROUP_CACHE = "com.atlassian.crowd.integration-group";
    private static final String GROUPNAMES_CACHE = "com.atlassian.crowd.integration-groupnames";
    private static final String GROUPNAME_CASE_CACHE = "com.atlassian.crowd.integration-groupname-case";
    private static final String PARENT_GROUPS_CACHE = "com.atlassian.crowd.integration-parentgroup";
    private static final String GROUP_MEMBERSHIP_CACHE = "com.atlassian.crowd.integration-group-membership";
    private static final String ALL_USER_MEMBERSHIPS_CACHE = "com.atlassian.crowd.integration-all-memberships";
    private static final String ALL_GROUP_MEMBERS_CACHE = "com.atlassian.crowd.integration-all-group-members";
    private static final String IS_USER_OR_GROUP_CACHE = "com.atlassian.crowd.integration-is-user-or-group";
    private static final String USERNAMES_KEY = "usernames";
    private static final String GROUPNAMES_KEY = "groupnames";
    private static final String ANCESTORS_BY_GROUP_KEY = "ancestorsByGroup";

    public CacheImpl(URL configLocation) {
        logger.info((Object)("config location: " + configLocation));
        this.ehCacheManager = new CacheManager(configLocation);
        this.createCachesIfNeeded();
    }

    public CacheImpl(CacheManager ehCacheManager) {
        this.ehCacheManager = ehCacheManager;
        this.createCachesIfNeeded();
    }

    private void createCachesIfNeeded() {
        this.createIfNeeded(USER_CACHE);
        this.createIfNeeded(USER_WITH_ATTRIBUTE_CACHE);
        this.createIfNeeded(USERNAMES_CACHE);
        this.createIfNeeded(USERNAME_CASE_CACHE);
        this.createIfNeeded(GROUP_CACHE);
        this.createIfNeeded(GROUPNAMES_CACHE);
        this.createIfNeeded(GROUPNAME_CASE_CACHE);
        this.createIfNeeded(PARENT_GROUPS_CACHE);
        this.createIfNeeded(GROUP_MEMBERSHIP_CACHE);
        this.createIfNeeded(ALL_USER_MEMBERSHIPS_CACHE);
        this.createIfNeeded(ALL_GROUP_MEMBERS_CACHE);
        this.createIfNeeded(IS_USER_OR_GROUP_CACHE);
    }

    private void createIfNeeded(String cacheName) {
        if (!this.ehCacheManager.cacheExists(cacheName)) {
            this.ehCacheManager.addCache(cacheName);
        }
    }

    private Cache getUserCache() {
        return this.ehCacheManager.getCache(USER_CACHE);
    }

    private Cache getUserNamesCache() {
        return this.ehCacheManager.getCache(USERNAMES_CACHE);
    }

    private Cache getGroupCache() {
        return this.ehCacheManager.getCache(GROUP_CACHE);
    }

    private Cache getGroupNamesCache() {
        return this.ehCacheManager.getCache(GROUPNAMES_CACHE);
    }

    private Cache getParentGroupsCache() {
        return this.ehCacheManager.getCache(PARENT_GROUPS_CACHE);
    }

    private Cache getGroupMembershipCache() {
        return this.ehCacheManager.getCache(GROUP_MEMBERSHIP_CACHE);
    }

    private Cache getUserMembershipsCache() {
        return this.ehCacheManager.getCache(ALL_USER_MEMBERSHIPS_CACHE);
    }

    private Cache getUserWithAttributeCache() {
        return this.ehCacheManager.getCache(USER_WITH_ATTRIBUTE_CACHE);
    }

    private Cache getGroupMembersCache() {
        return this.ehCacheManager.getCache(ALL_GROUP_MEMBERS_CACHE);
    }

    private Cache getIsUserOrGroupCache() {
        return this.ehCacheManager.getCache(IS_USER_OR_GROUP_CACHE);
    }

    private Cache getUserNameCaseCache() {
        return this.ehCacheManager.getCache(USERNAME_CASE_CACHE);
    }

    private Cache getGroupNameCaseCache() {
        return this.ehCacheManager.getCache(GROUPNAME_CASE_CACHE);
    }

    protected String getKey(String name) {
        if (name != null) {
            return IdentifierUtils.toLowerCase(name);
        }
        return name;
    }

    protected List<String> getKeys(List<String> names) {
        ArrayList<String> keys = new ArrayList<String>(names.size());
        for (String name : names) {
            keys.add(this.getKey(name));
        }
        return keys;
    }

    @Override
    public void flush() {
        this.ehCacheManager.clearAll();
    }

    @Override
    public void cacheUser(SOAPPrincipal user) {
        this.getUserCache().put(new Element((Serializable)((Object)this.getKey(user.getName())), (Serializable)user));
        this.getUserNameCaseCache().put(new Element((Serializable)((Object)this.getKey(user.getName())), (Serializable)((Object)user.getName())));
        Element element = this.getUserWithAttributeCache().get((Serializable)((Object)this.getKey(user.getName())));
        if (element != null && this.isUserDirty(user, (SOAPPrincipal)element.getValue())) {
            this.getUserWithAttributeCache().remove((Serializable)((Object)this.getKey(user.getName())));
        }
    }

    protected boolean isUserDirty(SOAPPrincipal latestSoapPrincipal, SOAPPrincipal cachedSoapPrincipal) {
        SOAPPrincipalHelper principalHelper = new SOAPPrincipalHelper();
        if (!StringUtils.equalsIgnoreCase((String)latestSoapPrincipal.getName(), (String)cachedSoapPrincipal.getName())) {
            throw new IllegalArgumentException("You cannot compare users with different usernames <" + latestSoapPrincipal.getName() + ">,<" + cachedSoapPrincipal + ">");
        }
        return !StringUtils.equals((String)latestSoapPrincipal.getName(), (String)cachedSoapPrincipal.getName()) || !StringUtils.equals((String)principalHelper.getFullName(latestSoapPrincipal), (String)principalHelper.getFullName(cachedSoapPrincipal)) || !StringUtils.equals((String)principalHelper.getFirstName(latestSoapPrincipal), (String)principalHelper.getFirstName(cachedSoapPrincipal)) || !StringUtils.equals((String)principalHelper.getLastName(latestSoapPrincipal), (String)principalHelper.getLastName(cachedSoapPrincipal)) || !StringUtils.equals((String)principalHelper.getEmail(latestSoapPrincipal), (String)principalHelper.getEmail(cachedSoapPrincipal));
    }

    @Override
    public void cacheUserWithAttributes(SOAPPrincipal user) {
        this.getUserCache().put(new Element((Serializable)((Object)this.getKey(user.getName())), (Serializable)user));
        this.getUserNameCaseCache().put(new Element((Serializable)((Object)this.getKey(user.getName())), (Serializable)((Object)user.getName())));
        this.getUserWithAttributeCache().put(new Element((Serializable)((Object)this.getKey(user.getName())), (Serializable)user));
    }

    @Override
    public boolean removeUser(String userName) {
        this.getUserWithAttributeCache().remove((Serializable)((Object)this.getKey(userName)));
        return this.getUserCache().remove((Serializable)((Object)this.getKey(userName)));
    }

    @Override
    public SOAPPrincipal getUser(String userName) {
        Element element = this.getUserCache().get((Serializable)((Object)this.getKey(userName)));
        if (element == null) {
            return null;
        }
        return (SOAPPrincipal)element.getValue();
    }

    @Override
    public SOAPPrincipal getUserWithAttributes(String userName) {
        Element element = this.getUserWithAttributeCache().get((Serializable)((Object)this.getKey(userName)));
        if (element == null) {
            return null;
        }
        return (SOAPPrincipal)element.getValue();
    }

    @Override
    public List getAllUserNames() {
        Element element = this.getUserNamesCache().get((Serializable)((Object)USERNAMES_KEY));
        if (element == null) {
            return null;
        }
        return (List)((Object)element.getValue());
    }

    @Override
    public void cacheAllUserNames(List userNames) {
        this.getUserNamesCache().put(new Element((Object)USERNAMES_KEY, (Object)userNames));
        for (String userName : userNames) {
            this.getUserNameCaseCache().put(new Element((Serializable)((Object)this.getKey(userName)), (Serializable)((Object)userName)));
        }
    }

    @Override
    public SOAPGroup getGroup(String groupName) {
        Element element = this.getGroupCache().get((Serializable)((Object)this.getKey(groupName)));
        if (element == null) {
            return null;
        }
        return (SOAPGroup)element.getValue();
    }

    @Override
    public void cacheGroup(SOAPGroup group) {
        this.getGroupCache().put(new Element((Serializable)((Object)this.getKey(group.getName())), (Serializable)group));
        this.getGroupNameCaseCache().put(new Element((Serializable)((Object)this.getKey(group.getName())), (Serializable)((Object)group.getName())));
    }

    @Override
    public void removeGroup(String groupName) {
        this.getGroupCache().remove((Serializable)((Object)this.getKey(groupName)));
        this.getGroupNamesCache().removeAll();
        this.getGroupNameCaseCache().remove((Serializable)((Object)this.getKey(groupName)));
    }

    @Override
    public List getAllGroupNames() {
        Element element = this.getGroupNamesCache().get((Serializable)((Object)GROUPNAMES_KEY));
        if (element == null) {
            return null;
        }
        return (List)((Object)element.getValue());
    }

    @Override
    public void cacheAllGroupNames(List groupNames) {
        this.getGroupNamesCache().put(new Element((Object)GROUPNAMES_KEY, (Object)groupNames));
        for (String groupName : groupNames) {
            this.getGroupNameCaseCache().put(new Element((Serializable)((Object)this.getKey(groupName)), (Serializable)((Object)groupName)));
        }
    }

    @Override
    public void cacheAncestorsForGroups(Map<String, Set<String>> ancestorsByGroup) {
        this.getParentGroupsCache().put(new Element((Object)ANCESTORS_BY_GROUP_KEY, ancestorsByGroup));
    }

    @Override
    public Map<String, Set<String>> getAncestorsForGroups() {
        Element element = this.getParentGroupsCache().get((Serializable)((Object)ANCESTORS_BY_GROUP_KEY));
        if (element == null) {
            return null;
        }
        return (Map)((Object)element.getValue());
    }

    @Override
    public boolean containsGroupRelationships() {
        return this.getAllGroupNames() != null;
    }

    @Override
    public Boolean isMemberInGroupCache(String userName, String groupName) {
        Boolean isMember = null;
        List allUsers = this.getAllMembers(this.getKey(groupName));
        if (allUsers != null) {
            isMember = allUsers.contains(this.getKey(userName));
        }
        return isMember;
    }

    @Override
    public void addGroupToUser(String userName, String groupName) {
        userName = this.getKey(userName);
        groupName = this.getKey(groupName);
        ArrayList<String> groups = this.getAllMemberships(userName);
        if (groups == null) {
            groups = new ArrayList<String>(1);
        }
        if (!groups.contains(groupName)) {
            groups.add(groupName);
            Collections.sort(groups);
            this.cacheAllMemberships(userName, groups);
        }
    }

    @Override
    public void addUserToGroup(String userName, String groupName) {
        userName = this.getKey(userName);
        ArrayList<String> users = this.getAllMembers(groupName = this.getKey(groupName));
        if (users == null) {
            users = new ArrayList<String>(1);
        }
        if (!users.contains(userName)) {
            users.add(userName);
            Collections.sort(users);
            this.cacheAllMembers(groupName, users);
        }
    }

    @Override
    public void removeGroupFromUser(String userName, String groupName) {
        List groupsForUser = this.getAllMemberships(this.getKey(userName));
        if (groupsForUser != null) {
            groupsForUser.remove(this.getKey(groupName));
        }
    }

    @Override
    public void removeUserFromGroup(String userName, String groupName) {
        List usersForGroup = this.getAllMembers(this.getKey(groupName));
        if (usersForGroup != null) {
            usersForGroup.remove(this.getKey(userName));
        }
    }

    @Override
    public List setMembers(String groupName, String[] userNameArray) {
        Assert.notNull(groupName);
        ArrayList<String> userNames = null;
        if (userNameArray != null && userNameArray.length > 0) {
            userNames = new ArrayList<String>(Arrays.asList(userNameArray));
            this.cacheAllMembers(groupName, userNames);
        }
        return userNames;
    }

    @Override
    public void removeCachedGroupMembership(String userName, String groupName) {
        Assert.notNull(userName);
        Assert.notNull(groupName);
        this.removeMembership(userName, groupName);
        this.removeGroupFromUser(userName, groupName);
    }

    @Override
    public void removeCachedGroupMemberships(String groupName) {
        Assert.notNull(groupName);
        List userNames = this.getAllMembers(groupName);
        if (userNames != null) {
            Iterator userIt = userNames.iterator();
            while (userIt.hasNext()) {
                this.removeCachedGroupMembership((String)userIt.next(), groupName);
            }
        }
        this.removeAllMembers(groupName);
    }

    @Override
    public void removeFromAllGroupNamesCache(String groupName) {
        Assert.notNull(groupName);
        List allGroups = this.getAllGroupNames();
        if (allGroups != null) {
            allGroups.remove(this.getKey(groupName));
        }
    }

    @Override
    public void addToAllGroupNamesCache(String groupName) {
        Assert.notNull(groupName);
        List allGroups = this.getAllGroupNames();
        if (allGroups != null && !allGroups.contains(groupName)) {
            allGroups.add(groupName);
            Collections.sort(allGroups);
        }
        this.getGroupNameCaseCache().put(new Element((Serializable)((Object)this.getKey(groupName)), (Serializable)((Object)groupName)));
    }

    @Override
    public void removeCachedUser(String userName, String groupName) {
        Assert.notNull(userName);
        Assert.notNull(groupName);
        this.removeMembership(userName, groupName);
        this.removeUserFromGroup(userName, groupName);
    }

    @Override
    public void removeAllMemberships(String userName) {
        Assert.notNull(userName);
        List groups = this.getAllMemberships(userName);
        if (groups != null) {
            Iterator groupIt = groups.iterator();
            while (groupIt.hasNext()) {
                this.removeCachedUser(userName, (String)groupIt.next());
            }
        }
        this.removeAllMembershipsFromUserMembershipsCache(userName);
    }

    @Override
    public void setMembership(String userName, String groupName, Boolean isMember) {
        Assert.notNull(isMember);
        this.getGroupMembershipCache().put(new Element((Serializable)new UserGroupKey(this.getKey(userName), this.getKey(groupName)), (Serializable)isMember));
    }

    @Override
    public void removeMembership(String userName, String groupName) {
        this.getGroupMembershipCache().remove((Serializable)new UserGroupKey(this.getKey(userName), this.getKey(groupName)));
    }

    @Override
    public Boolean isMember(String userName, String groupName) {
        Element element = this.getGroupMembershipCache().get((Serializable)new UserGroupKey(this.getKey(userName), this.getKey(groupName)));
        if (element == null) {
            return null;
        }
        return (Boolean)element.getValue();
    }

    @Override
    public List getAllMemberships(String userName) {
        Element element = this.getUserMembershipsCache().get((Serializable)((Object)this.getKey(userName)));
        if (element == null) {
            return null;
        }
        return (List)((Object)element.getValue());
    }

    @Override
    public void cacheAllMemberships(String userName, List groupNames) {
        this.getUserMembershipsCache().put(new Element((Object)this.getKey(userName), this.getKeys(groupNames)));
    }

    @Override
    public void removeAllMembershipsFromUserMembershipsCache(String userName) {
        this.getUserMembershipsCache().remove((Serializable)((Object)this.getKey(userName)));
    }

    @Override
    public List getAllMembers(String groupName) {
        Element element = this.getGroupMembersCache().get((Serializable)((Object)this.getKey(groupName)));
        if (element == null) {
            return null;
        }
        return (List)((Object)element.getValue());
    }

    @Override
    public void cacheAllMembers(String groupName, List userNames) {
        this.getGroupMembersCache().put(new Element((Object)this.getKey(groupName), this.getKeys(userNames)));
    }

    @Override
    public void removeAllMembers(String groupName) {
        this.getGroupMembersCache().remove((Serializable)((Object)this.getKey(groupName)));
    }

    @Override
    public Boolean isUserOrGroup(String name) {
        Boolean isUserInGroup = null;
        Element element = this.getIsUserOrGroupCache().get((Serializable)((Object)this.getKey(name)));
        if (element != null) {
            isUserInGroup = (Boolean)element.getValue();
        }
        return isUserInGroup;
    }

    @Override
    public void addIsUserOrGroup(String name, Boolean isValidUserOrGroup) {
        this.getIsUserOrGroupCache().put(new Element((Serializable)((Object)this.getKey(name)), (Serializable)isValidUserOrGroup));
    }

    @Override
    public void addToAllUsers(String userName) {
        Assert.notNull(userName);
        List userNames = this.getAllUserNames();
        if (userNames != null) {
            if (!userNames.contains(userName)) {
                userNames.add(userName);
                Collections.sort(userNames);
            }
            this.getUserNameCaseCache().put(new Element((Serializable)((Object)this.getKey(userName)), (Serializable)((Object)userName)));
        }
    }

    @Override
    public void removeFromAllUsers(String userName) {
        Assert.notNull(userName);
        List userNames = this.getAllUserNames();
        if (userNames != null) {
            Iterator iterator = userNames.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                if (!userName.equalsIgnoreCase(name)) continue;
                iterator.remove();
                break;
            }
        }
    }

    @Override
    public String getUserName(String username) {
        Element element = this.getUserNameCaseCache().get((Serializable)((Object)this.getKey(username)));
        if (element != null) {
            return (String)((Object)element.getValue());
        }
        return null;
    }

    @Override
    public String getGroupName(String groupname) {
        Element element = this.getGroupNameCaseCache().get((Serializable)((Object)this.getKey(groupname)));
        if (element != null) {
            return (String)((Object)element.getValue());
        }
        return null;
    }

    private static class UserGroupKey
    implements Serializable {
        private String userName;
        private String groupName;

        UserGroupKey(String userName, String groupName) {
            Assert.notNull(userName);
            Assert.notNull(groupName);
            this.userName = userName;
            this.groupName = groupName;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof UserGroupKey)) {
                return false;
            }
            UserGroupKey other = (UserGroupKey)o;
            return this.userName.equals(other.userName) && this.groupName.equals(other.groupName);
        }

        public int hashCode() {
            return this.userName.hashCode() / 2 + this.groupName.hashCode() / 2;
        }
    }
}

