/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.osuser.providers;

import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.service.UserManager;
import com.atlassian.crowd.service.cache.CacheExpiryManager;
import com.atlassian.crowd.service.cache.CachingManagerFactory;
import com.atlassian.crowd.util.Assert;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.user.Entity;
import com.opensymphony.user.provider.ProfileProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class ChainedProfileProvider
implements ProfileProvider {
    protected final Logger logger = Logger.getLogger(this.getClass());
    private static final Category log = Category.getInstance(ChainedProfileProvider.class);
    public static final String PROPERTY_NAME_KEY = "name";
    protected static final String ssoPropertySetName = "crowd";
    private ProfileProvider nextProvider;
    private final UserManager userManager;
    private final CacheExpiryManager cacheExpiryManager;

    public ChainedProfileProvider() {
        this(CachingManagerFactory.getUserManagerInstance(), CachingManagerFactory.getCacheExpiryManagerInstance());
    }

    public ChainedProfileProvider(UserManager userManager, CacheExpiryManager cacheExpiryManager) {
        this.userManager = userManager;
        this.cacheExpiryManager = cacheExpiryManager;
    }

    public boolean init(Properties properties) {
        if (!properties.containsKey("chain.classname") || properties.getProperty("chain.classname").length() == 0) {
            log.error((Object)"ChainedUserProvider requires a 'chain.classname' init property to determine next class in chain");
            return false;
        }
        try {
            Class<?> next = Class.forName(properties.getProperty("chain.classname"));
            if (!this.getProviderClass().isAssignableFrom(next)) {
                log.error((Object)("Configured chained class " + next.getName() + " is not of expected type " + this.getProviderClass().getName()));
                return false;
            }
            this.nextProvider = (ProfileProvider)next.newInstance();
            return this.nextProvider.init(this.extractChainedProperties(properties));
        }
        catch (Exception e) {
            log.error((Object)("Unable to instantiate chained access provider class " + properties.getProperty("chain.classname")), (Throwable)e);
            return false;
        }
    }

    private Properties extractChainedProperties(Properties properties) {
        Properties newProps = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("chain.") || key.equals("chain.classname") || key.length() <= 6) continue;
            newProps.put(key.substring(6), entry.getValue());
        }
        return newProps;
    }

    public PropertySet getPropertySet(String user) {
        PropertySet chainedProviderPS;
        ArrayList<PropertySet> propertySets = new ArrayList<PropertySet>();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(PROPERTY_NAME_KEY, user);
        PropertySet crowdPS = PropertySetManager.getInstance((String)ssoPropertySetName, args);
        if (crowdPS != null) {
            propertySets.add(crowdPS);
        }
        if ((chainedProviderPS = this.nextProvider.getPropertySet(user)) != null) {
            propertySets.add(chainedProviderPS);
        }
        args.clear();
        args.put("PropertySets", propertySets);
        return PropertySetManager.getInstance((String)"aggregate", args);
    }

    protected Class getProviderClass() {
        return ProfileProvider.class;
    }

    public boolean handles(String name) {
        Assert.notNull(name);
        try {
            return this.userManager.getUser(name) != null;
        }
        catch (UserNotFoundException e) {
            this.logger.debug((Object)("This provider does not handle " + name));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public void flushCaches() {
        this.cacheExpiryManager.flush();
    }

    public List list() {
        try {
            return this.userManager.getAllUserNames();
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public boolean create(String name) {
        return true;
    }

    public boolean remove(String name) {
        return false;
    }

    public boolean store(String name, Entity.Accessor accessor) {
        return false;
    }

    public boolean load(String string, Entity.Accessor accessor) {
        accessor.setMutable(true);
        return true;
    }
}

