/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.acegi;

import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.acegi.CrowdAuthenticationProvider;
import com.atlassian.crowd.integration.acegi.CrowdSSOTokenInvalidException;
import com.atlassian.crowd.integration.acegi.user.CrowdUserDetails;
import com.atlassian.crowd.integration.acegi.user.CrowdUserDetailsService;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.service.AuthenticationManager;
import java.rmi.RemoteException;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.dao.DataAccessException;

public class RemoteCrowdAuthenticationProvider
extends CrowdAuthenticationProvider {
    protected final AuthenticationManager authenticationManager;
    protected final HttpAuthenticator httpAuthenticator;
    protected final CrowdUserDetailsService userDetailsService;

    public RemoteCrowdAuthenticationProvider(AuthenticationManager authenticationManager, HttpAuthenticator httpAuthenticator, CrowdUserDetailsService userDetailsService) {
        super(httpAuthenticator.getSoapClientProperties().getApplicationName());
        this.authenticationManager = authenticationManager;
        this.httpAuthenticator = httpAuthenticator;
        this.userDetailsService = userDetailsService;
    }

    protected boolean isAuthenticated(String token, ValidationFactor[] validationFactors) throws InvalidAuthorizationTokenException, RemoteException, ApplicationAccessDeniedException, InvalidAuthenticationException {
        return this.authenticationManager.isAuthenticated(token, validationFactors);
    }

    protected String authenticate(String username, String password, ValidationFactor[] validationFactors) throws InvalidAuthorizationTokenException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        return this.httpAuthenticator.verifyAuthentication(username, password, validationFactors);
    }

    protected CrowdUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.userDetailsService.loadUserByUsername(username);
    }

    protected CrowdUserDetails loadUserByToken(String token) throws CrowdSSOTokenInvalidException, DataAccessException {
        return this.userDetailsService.loadUserByToken(token);
    }
}

