/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.rest.util;

import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.integration.rest.entity.AttributeEntity;
import com.atlassian.crowd.integration.rest.entity.AttributeEntityList;
import com.atlassian.crowd.integration.rest.entity.GroupEntity;
import com.atlassian.crowd.integration.rest.entity.GroupEntityList;
import com.atlassian.crowd.integration.rest.entity.PasswordEntity;
import com.atlassian.crowd.integration.rest.entity.UserEntity;
import com.atlassian.crowd.integration.rest.entity.UserEntityList;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityTranslator {
    private EntityTranslator() {
    }

    public static UserEntity toUserEntity(User user) {
        return EntityTranslator.toUserEntity(user, (PasswordCredential)null);
    }

    public static UserEntity toUserEntity(User user, PasswordCredential passwordCredential) {
        if (user == null) {
            return null;
        }
        PasswordEntity password = null;
        if (passwordCredential != null) {
            password = new PasswordEntity(passwordCredential.getCredential());
        }
        UserEntity userEntity = new UserEntity(user.getName(), user.getFirstName(), user.getLastName(), user.getDisplayName(), user.getEmailAddress(), password, user.isActive());
        return userEntity;
    }

    public static UserEntity toUserEntity(User user, Attributes attributes) {
        if (user == null) {
            return null;
        }
        Validate.notNull((Object)attributes);
        UserEntity userEntity = EntityTranslator.toUserEntity(user);
        userEntity.setAttributes(EntityTranslator.toAttributeEntityList(attributes));
        return userEntity;
    }

    public static GroupEntity toGroupEntity(Group group) {
        return new GroupEntity(group.getName(), group.getDescription(), group.getType(), group.isActive());
    }

    public static GroupEntity toGroupEntity(Group group, Attributes attributes) {
        GroupEntity groupEntity = EntityTranslator.toGroupEntity(group);
        groupEntity.setAttributes(EntityTranslator.toAttributeEntityList(attributes));
        return groupEntity;
    }

    public static AttributeEntityList toAttributeEntityList(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        Set<String> keys = attributes.getKeys();
        ArrayList<AttributeEntity> attributeList = new ArrayList<AttributeEntity>(keys.size());
        for (String key : keys) {
            attributeList.add(new AttributeEntity(key, attributes.getValues(key)));
        }
        return new AttributeEntityList(attributeList);
    }

    public static AttributeEntityList toAttributeEntityList(Map<String, Set<String>> attributes) {
        if (attributes == null) {
            return null;
        }
        ArrayList<AttributeEntity> attributeEntities = new ArrayList<AttributeEntity>(attributes.size());
        for (Map.Entry<String, Set<String>> attribute : attributes.entrySet()) {
            attributeEntities.add(new AttributeEntity(attribute.getKey(), (Collection<String>)attribute.getValue()));
        }
        return new AttributeEntityList(attributeEntities);
    }

    public static List<Group> toGroupList(GroupEntityList groupEntityList) {
        ArrayList<Group> groups = new ArrayList<Group>(groupEntityList.size());
        for (GroupEntity groupEntity : groupEntityList) {
            groups.add(groupEntity);
        }
        return groups;
    }

    public static List<String> toNameList(GroupEntityList groupEntityList) {
        ArrayList<String> names = new ArrayList<String>(groupEntityList.size());
        for (GroupEntity groupEntity : groupEntityList) {
            names.add(groupEntity.getName());
        }
        return names;
    }

    public static List<User> toUserList(UserEntityList userEntityList) {
        ArrayList<User> users = new ArrayList<User>(userEntityList.size());
        for (UserEntity userEntity : userEntityList) {
            users.add(userEntity);
        }
        return users;
    }

    public static List<String> toNameList(UserEntityList userEntityList) {
        ArrayList<String> names = new ArrayList<String>(userEntityList.size());
        for (UserEntity userEntity : userEntityList) {
            names.add(userEntity.getName());
        }
        return names;
    }
}

