/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.soap.client;

import com.atlassian.crowd.integration.authentication.AuthenticatedToken;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.UserAuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidEmailAddressException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidRoleException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.soap.client.CleaningHttpMessageSender;
import com.atlassian.crowd.integration.service.soap.client.ClientProperties;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.service.soap.server.SecurityServer;
import com.atlassian.crowd.integration.service.soap.xfire.XFireFaultLoggingMethodHandler;
import com.atlassian.crowd.integration.service.soap.xfire.XFireInLoggingMethodHandler;
import com.atlassian.crowd.integration.service.soap.xfire.XFireOutLoggingMethodHandler;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPCookieInfo;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPNestableGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SOAPRole;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.client.XFireProxy;
import org.codehaus.xfire.client.XFireProxyFactory;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.util.dom.DOMInHandler;
import org.codehaus.xfire.util.dom.DOMOutHandler;

public class SecurityServerClientImpl
implements SecurityServerClient {
    private static final Logger logger = Logger.getLogger(SecurityServerClientImpl.class);
    private static final String USER_AGENT = "Mozilla/5.0 (Crowd Client 2.0.1; XFire Client)";
    protected AuthenticatedToken applicationToken;
    protected Service service;
    protected XFireProxyFactory factory;
    private final ClientProperties clientProperties;

    public SecurityServerClientImpl(ClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    protected SecurityServer getSecurityServer() throws RemoteException {
        try {
            if (this.service == null) {
                this.service = new ObjectServiceFactory(XFireFactory.newInstance().getXFire().getTransportManager()).create(SecurityServer.class, "SecurityServer", "urn:SecurityServer", null);
                this.service.addInHandler((Handler)new DOMInHandler());
                this.service.addOutHandler((Handler)new DOMOutHandler());
                this.service.addFaultHandler((Handler)new DOMOutHandler());
                this.service.addInHandler((Handler)new XFireInLoggingMethodHandler());
                this.service.addOutHandler((Handler)new XFireOutLoggingMethodHandler());
                this.service.addFaultHandler((Handler)new XFireFaultLoggingMethodHandler());
                this.service.setProperty("messageSender.className", (Object)CleaningHttpMessageSender.class.getName());
            }
            if (this.factory == null) {
                this.factory = new XFireProxyFactory();
            }
            logger.debug((Object)("Connection URL: " + this.clientProperties.getSecurityServerURL()));
            SecurityServer securityServer = (SecurityServer)this.factory.create(this.service, this.clientProperties.getSecurityServerURL());
            Client client = ((XFireProxy)Proxy.getInvocationHandler(securityServer)).getClient();
            client.setProperty("gzip.response.enabled", (Object)Boolean.TRUE);
            HashMap<String, String> headers = new HashMap<String, String>(1);
            headers.put("User-Agent", USER_AGENT);
            client.setProperty("http.custom.headers.map", headers);
            if (this.clientProperties.getHttpProxyHost() != null && this.clientProperties.getHttpProxyPort() != null) {
                client.setProperty("http.proxyHost", (Object)this.clientProperties.getHttpProxyHost());
                client.setProperty("http.proxyPort", (Object)this.clientProperties.getHttpProxyPort());
                if (this.clientProperties.getHttpProxyUsername() != null && this.clientProperties.getHttpProxyPassword() != null) {
                    client.setProperty("http.proxy.user", (Object)this.clientProperties.getHttpProxyUsername());
                    client.setProperty("http.proxy.password", (Object)this.clientProperties.getHttpProxyPassword());
                }
            }
            if (this.clientProperties.getHttpMaxConnections() != null) {
                client.setProperty("max.total.connections", (Object)this.clientProperties.getHttpMaxConnections());
                client.setProperty("max.connections.per.host", (Object)this.clientProperties.getHttpMaxConnections());
            }
            if (this.clientProperties.getHttpTimeout() != null) {
                client.setProperty("http.timeout", (Object)this.clientProperties.getHttpTimeout());
            }
            return securityServer;
        }
        catch (Exception e) {
            String error = "Unable to connect to crowd server URL: " + this.clientProperties.getSecurityServerURL();
            logger.fatal((Object)error, (Throwable)e);
            throw new RemoteException(error, e);
        }
    }

    public AuthenticatedToken getApplicationToken() throws RemoteException, InvalidAuthorizationTokenException {
        if (this.applicationToken == null) {
            logger.info((Object)"Existing application token is null, authenticating ...");
            this.authenticate();
            logger.info((Object)("Using existing token: " + this.applicationToken.getToken()));
        }
        logger.debug((Object)("Using existing token: " + this.applicationToken.getToken()));
        return this.applicationToken;
    }

    public void authenticate() throws RemoteException, InvalidAuthorizationTokenException {
        try {
            this.applicationToken = this.getSecurityServer().authenticateApplication(this.clientProperties.getApplicationAuthenticationContext());
            if (this.applicationToken == null) {
                throw new InvalidAuthorizationTokenException();
            }
        }
        catch (InvalidAuthenticationException e) {
            throw new InvalidAuthorizationTokenException(e.getMessage(), e);
        }
    }

    public String authenticatePrincipal(UserAuthenticationContext userAuthenticationContext) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException {
        try {
            return this.getSecurityServer().authenticatePrincipal(this.getApplicationToken(), userAuthenticationContext);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().authenticatePrincipal(this.getApplicationToken(), userAuthenticationContext);
        }
    }

    public boolean isValidToken(String principalToken, ValidationFactor[] validationFactors) throws RemoteException, InvalidAuthorizationTokenException, ApplicationAccessDeniedException {
        try {
            return this.getSecurityServer().isValidPrincipalToken(this.getApplicationToken(), principalToken, validationFactors);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().isValidPrincipalToken(this.getApplicationToken(), principalToken, validationFactors);
        }
    }

    public void invalidateToken(String token) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            this.getSecurityServer().invalidatePrincipalToken(this.getApplicationToken(), token);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            this.getSecurityServer().invalidatePrincipalToken(this.getApplicationToken(), token);
        }
    }

    public SOAPGroup[] searchGroups(SearchRestriction[] searchRestrictions) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            return this.getSecurityServer().searchGroups(this.getApplicationToken(), searchRestrictions);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().searchGroups(this.getApplicationToken(), searchRestrictions);
        }
    }

    public SOAPPrincipal[] searchPrincipals(SearchRestriction[] searchRestrictions) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            return this.getSecurityServer().searchPrincipals(this.getApplicationToken(), searchRestrictions);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().searchPrincipals(this.getApplicationToken(), searchRestrictions);
        }
    }

    public SOAPRole[] searchRoles(SearchRestriction[] searchRestrictions) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            return this.getSecurityServer().searchRoles(this.getApplicationToken(), searchRestrictions);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().searchRoles(this.getApplicationToken(), searchRestrictions);
        }
    }

    public SOAPGroup[] findAllGroups() throws RemoteException, InvalidAuthorizationTokenException {
        SearchRestriction[] searchRestrictions = new SearchRestriction[]{};
        return this.searchGroups(searchRestrictions);
    }

    public SOAPRole[] findAllRoles() throws RemoteException, InvalidAuthorizationTokenException {
        SearchRestriction[] searchRestrictions = new SearchRestriction[]{};
        return this.searchRoles(searchRestrictions);
    }

    public SOAPPrincipal[] findAllPrincipals() throws RemoteException, InvalidAuthorizationTokenException {
        SearchRestriction[] searchRestrictions = new SearchRestriction[]{};
        return this.searchPrincipals(searchRestrictions);
    }

    public SOAPGroup addGroup(SOAPGroup group) throws RemoteException, InvalidGroupException, InvalidAuthorizationTokenException, ApplicationPermissionException {
        try {
            return this.getSecurityServer().addGroup(this.getApplicationToken(), group);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().addGroup(this.getApplicationToken(), group);
        }
    }

    public void updateGroup(String group, String description, boolean active) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException {
        try {
            this.getSecurityServer().updateGroup(this.getApplicationToken(), group, description, active);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            this.getSecurityServer().updateGroup(this.getApplicationToken(), group, description, active);
        }
    }

    public SOAPGroup findGroupByName(String name) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        try {
            return this.getSecurityServer().findGroupByName(this.getApplicationToken(), name);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().findGroupByName(this.getApplicationToken(), name);
        }
    }

    public SOAPRole addRole(SOAPRole role) throws RemoteException, InvalidAuthorizationTokenException, InvalidRoleException, ApplicationPermissionException {
        try {
            return this.getSecurityServer().addRole(this.getApplicationToken(), role);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().addRole(this.getApplicationToken(), role);
        }
    }

    public SOAPRole findRoleByName(String name) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        try {
            return this.getSecurityServer().findRoleByName(this.getApplicationToken(), name);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().findRoleByName(this.getApplicationToken(), name);
        }
    }

    public SOAPPrincipal findPrincipalByToken(String key) throws RemoteException, InvalidTokenException, InvalidAuthorizationTokenException {
        try {
            return this.getSecurityServer().findPrincipalByToken(this.getApplicationToken(), key);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().findPrincipalByToken(this.getApplicationToken(), key);
        }
    }

    public void updatePrincipalAttribute(String name, SOAPAttribute attribute) throws RemoteException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException {
        try {
            this.getSecurityServer().updatePrincipalAttribute(this.getApplicationToken(), name, attribute);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            this.getSecurityServer().updatePrincipalAttribute(this.getApplicationToken(), name, attribute);
        }
    }

    public SOAPPrincipal findPrincipalByName(String name) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        try {
            return this.getSecurityServer().findPrincipalByName(this.getApplicationToken(), name);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().findPrincipalByName(this.getApplicationToken(), name);
        }
    }

    public SOAPPrincipal addPrincipal(SOAPPrincipal principal, PasswordCredential credential) throws RemoteException, InvalidAuthorizationTokenException, InvalidCredentialException, InvalidUserException, ApplicationPermissionException {
        try {
            return this.getSecurityServer().addPrincipal(this.getApplicationToken(), principal, credential);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().addPrincipal(this.getApplicationToken(), principal, credential);
        }
    }

    public void addPrincipalToGroup(String principal, String group) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        try {
            this.getSecurityServer().addPrincipalToGroup(this.getApplicationToken(), principal, group);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            this.getSecurityServer().addPrincipalToGroup(this.getApplicationToken(), principal, group);
        }
    }

    public void updatePrincipalCredential(String principal, PasswordCredential credential) throws RemoteException, InvalidAuthorizationTokenException, InvalidCredentialException, ObjectNotFoundException, ApplicationPermissionException {
        try {
            this.getSecurityServer().updatePrincipalCredential(this.getApplicationToken(), principal, credential);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            this.getSecurityServer().updatePrincipalCredential(this.getApplicationToken(), principal, credential);
        }
    }

    public void resetPrincipalCredential(String principal) throws RemoteException, InvalidEmailAddressException, InvalidCredentialException, ObjectNotFoundException, ApplicationPermissionException, InvalidAuthorizationTokenException {
        try {
            this.getSecurityServer().resetPrincipalCredential(this.getApplicationToken(), principal);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            this.getSecurityServer().resetPrincipalCredential(this.getApplicationToken(), principal);
        }
    }

    public void removeGroup(String group) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        try {
            this.getSecurityServer().removeGroup(this.getApplicationToken(), group);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            this.getSecurityServer().removeGroup(this.getApplicationToken(), group);
        }
    }

    public void removeRole(String role) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        try {
            this.getSecurityServer().removeRole(this.getApplicationToken(), role);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            this.getSecurityServer().removeRole(this.getApplicationToken(), role);
        }
    }

    public void removePrincipal(String principal) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        try {
            this.getSecurityServer().removePrincipal(this.getApplicationToken(), principal);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            this.getSecurityServer().removePrincipal(this.getApplicationToken(), principal);
        }
    }

    public void addPrincipalToRole(String principal, String role) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        try {
            this.getSecurityServer().addPrincipalToRole(this.getApplicationToken(), principal, role);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            this.getSecurityServer().addPrincipalToRole(this.getApplicationToken(), principal, role);
        }
    }

    public boolean isGroupMember(String group, String principal) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            return this.getSecurityServer().isGroupMember(this.getApplicationToken(), group, principal);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().isGroupMember(this.getApplicationToken(), group, principal);
        }
    }

    public boolean isRoleMember(String role, String principal) throws RemoteException, InvalidAuthorizationTokenException {
        try {
            return this.getSecurityServer().isRoleMember(this.getApplicationToken(), role, principal);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().isRoleMember(this.getApplicationToken(), role, principal);
        }
    }

    public void removePrincipalFromGroup(String principal, String group) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        try {
            this.getSecurityServer().removePrincipalFromGroup(this.getApplicationToken(), principal, group);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            this.getSecurityServer().removePrincipalFromGroup(this.getApplicationToken(), principal, group);
        }
    }

    public void removePrincipalFromRole(String principal, String role) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        try {
            this.getSecurityServer().removePrincipalFromRole(this.getApplicationToken(), principal, role);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            this.getSecurityServer().removePrincipalFromRole(this.getApplicationToken(), principal, role);
        }
    }

    public void addAttributeToPrincipal(String principal, SOAPAttribute attribute) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        try {
            this.getSecurityServer().addAttributeToPrincipal(this.getApplicationToken(), principal, attribute);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            this.getSecurityServer().addAttributeToPrincipal(this.getApplicationToken(), principal, attribute);
        }
    }

    public void removeAttributeFromPrincipal(String principal, String attribute) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        try {
            this.getSecurityServer().removeAttributeFromPrincipal(this.getApplicationToken(), principal, attribute);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            this.getSecurityServer().removeAttributeFromPrincipal(this.getApplicationToken(), principal, attribute);
        }
    }

    public long getCacheTime() throws RemoteException, InvalidAuthorizationTokenException {
        try {
            return this.getSecurityServer().getCacheTime(this.getApplicationToken());
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().getCacheTime(this.getApplicationToken());
        }
    }

    public boolean isCacheEnabled() throws RemoteException, InvalidAuthorizationTokenException {
        try {
            return this.getSecurityServer().isCacheEnabled(this.getApplicationToken());
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().isCacheEnabled(this.getApplicationToken());
        }
    }

    public String getDomain() throws RemoteException, InvalidAuthorizationTokenException {
        try {
            return this.getSecurityServer().getDomain(this.getApplicationToken());
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().getDomain(this.getApplicationToken());
        }
    }

    public String[] findAllPrincipalNames() throws RemoteException, InvalidAuthorizationTokenException {
        try {
            return this.getSecurityServer().findAllPrincipalNames(this.getApplicationToken());
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().findAllPrincipalNames(this.getApplicationToken());
        }
    }

    public String[] findAllGroupNames() throws RemoteException, InvalidAuthorizationTokenException {
        try {
            return this.getSecurityServer().findAllGroupNames(this.getApplicationToken());
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().findAllGroupNames(this.getApplicationToken());
        }
    }

    public SOAPNestableGroup[] findAllGroupRelationships() throws RemoteException, InvalidAuthorizationTokenException {
        try {
            return this.getSecurityServer().findAllGroupRelationships(this.getApplicationToken());
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().findAllGroupRelationships(this.getApplicationToken());
        }
    }

    public String[] findAllRoleNames() throws RemoteException, InvalidAuthorizationTokenException {
        try {
            return this.getSecurityServer().findAllRoleNames(this.getApplicationToken());
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().findAllRoleNames(this.getApplicationToken());
        }
    }

    public String[] findGroupMemberships(String principalName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        try {
            return this.getSecurityServer().findGroupMemberships(this.getApplicationToken(), principalName);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().findGroupMemberships(this.getApplicationToken(), principalName);
        }
    }

    public String[] findRoleMemberships(String principalName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        try {
            return this.getSecurityServer().findRoleMemberships(this.getApplicationToken(), principalName);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().findRoleMemberships(this.getApplicationToken(), principalName);
        }
    }

    public String authenticatePrincipalSimple(String username, String password) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException {
        try {
            return this.getSecurityServer().authenticatePrincipalSimple(this.getApplicationToken(), username, password);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().authenticatePrincipalSimple(this.getApplicationToken(), username, password);
        }
    }

    public String createPrincipalToken(String username, ValidationFactor[] validationFactors) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException {
        try {
            return this.getSecurityServer().createPrincipalToken(this.getApplicationToken(), username, validationFactors);
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().createPrincipalToken(this.getApplicationToken(), username, validationFactors);
        }
    }

    public String[] getGrantedAuthorities() throws InvalidAuthorizationTokenException, RemoteException {
        try {
            return this.getSecurityServer().getGrantedAuthorities(this.getApplicationToken());
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().getGrantedAuthorities(this.getApplicationToken());
        }
    }

    public SOAPCookieInfo getCookieInfo() throws RemoteException, InvalidAuthorizationTokenException {
        try {
            return this.getSecurityServer().getCookieInfo(this.getApplicationToken());
        }
        catch (InvalidAuthorizationTokenException e) {
            this.authenticate();
            return this.getSecurityServer().getCookieInfo(this.getApplicationToken());
        }
    }

    public ClientProperties getClientProperties() {
        return this.clientProperties;
    }
}

