/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.soap.xfire;

import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.exchange.MessageExchange;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.handler.AbstractHandler;
import org.codehaus.xfire.service.OperationInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XFireFaultLoggingMethodHandler
extends AbstractHandler {
    private static final Logger logger = LoggerFactory.getLogger(XFireFaultLoggingMethodHandler.class);

    public void invoke(MessageContext messageContext) throws Exception {
        if (logger.isDebugEnabled()) {
            MessageExchange messageExchange = messageContext.getExchange();
            OperationInfo operationInfo = messageExchange.getOperation();
            StringBuffer logMessage = new StringBuffer(512);
            if (messageExchange.getFaultMessage().getBody() instanceof XFireFault) {
                XFireFault fault = (XFireFault)messageExchange.getFaultMessage().getBody();
                if (fault.getMessage() != null) {
                    logMessage.append("\n").append(fault.getMessage());
                }
                if (fault.hasDetails()) {
                    logMessage.append("\n").append(fault.getDetail());
                }
            }
            if (messageExchange.getFaultMessage().getBody() instanceof Throwable) {
                Throwable logThrowable = (Throwable)messageExchange.getFaultMessage().getBody();
                logger.debug("SOAP service fault for method: " + operationInfo.getName() + logMessage.toString(), logThrowable);
            } else {
                if (logMessage.length() == 0) {
                    logMessage.append("\n").append("Message, detail or cause for fault found.");
                }
                logger.debug("SOAP service fault for method: " + operationInfo.getName() + logMessage.toString());
            }
        }
    }
}

