/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.cache;

import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPNestableGroup;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import com.atlassian.crowd.service.GroupManager;
import com.atlassian.crowd.service.cache.BasicCache;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.util.NestingHelper;
import com.google.common.base.Preconditions;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.List;

public class CachingGroupManager
implements GroupManager {
    private final Server server;
    private final BasicCache basicCache;
    private final Object basicCacheLock = new Object();

    public CachingGroupManager(SecurityServerClient securityServerClient, BasicCache basicCache) {
        this.server = new Server(securityServerClient);
        this.basicCache = basicCache;
    }

    @Override
    public boolean isGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        Preconditions.checkNotNull((Object)groupName);
        List groupNames = this.getAllGroupNames();
        if (groupNames != null) {
            return groupNames.contains(groupName);
        }
        return false;
    }

    @Override
    public SOAPGroup getGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, GroupNotFoundException {
        Preconditions.checkNotNull((Object)groupName);
        SOAPGroup group = this.basicCache.getGroup(groupName);
        if (group == null) {
            group = this.server.getGroup(groupName);
            this.basicCache.setMembers(groupName, group.getMembers());
            this.basicCache.cacheGroup(group);
        }
        group.setMembers(null);
        return group;
    }

    @Override
    public SOAPGroup addGroup(SOAPGroup group) throws RemoteException, InvalidGroupException, InvalidAuthorizationTokenException, ApplicationPermissionException, InvalidAuthenticationException {
        Preconditions.checkNotNull((Object)group);
        Preconditions.checkNotNull((Object)group.getName());
        group = this.server.addGroup(group);
        this.basicCache.cacheGroup(group);
        this.basicCache.addToAllGroupNamesCache(group.getName());
        return group;
    }

    @Override
    public List searchGroups(SearchRestriction[] restrictions) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        return this.server.searchGroups(restrictions);
    }

    @Override
    public void updateGroup(SOAPGroup group) throws RemoteException, ApplicationPermissionException, InvalidAuthorizationTokenException, InvalidAuthenticationException, GroupNotFoundException {
        Preconditions.checkNotNull((Object)group);
        this.server.updateGroup(group);
        this.basicCache.cacheGroup(group);
    }

    @Override
    public void removeGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, InvalidAuthenticationException, GroupNotFoundException {
        Preconditions.checkNotNull((Object)groupName);
        this.server.removeGroup(groupName);
        this.basicCache.removeGroup(groupName);
        this.basicCache.removeCachedGroupMemberships(groupName);
        this.basicCache.removeFromAllGroupNamesCache(groupName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getAllGroupNames() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        List<String> groupNames = this.basicCache.getAllGroupNames();
        if (groupNames != null) {
            return groupNames;
        }
        Object object = this.basicCacheLock;
        synchronized (object) {
            SOAPNestableGroup[] allGroupRelationships;
            groupNames = this.basicCache.getAllGroupNames();
            if (groupNames == null && (allGroupRelationships = this.server.getAllGroupRelationships()) != null) {
                groupNames = NestingHelper.cacheGroupRelationships(allGroupRelationships, this.basicCache);
            }
            return groupNames;
        }
    }

    private class Server {
        private final SecurityServerClient ssc;

        public Server(SecurityServerClient securityServerClient) {
            this.ssc = securityServerClient;
        }

        public SOAPGroup getGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, GroupNotFoundException {
            return this.ssc.findGroupByName(groupName);
        }

        public List searchGroups(SearchRestriction[] restrictions) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
            SOAPGroup[] groups = this.ssc.searchGroups(restrictions);
            return Arrays.asList(groups);
        }

        public SOAPGroup addGroup(SOAPGroup group) throws RemoteException, ApplicationPermissionException, InvalidAuthorizationTokenException, InvalidGroupException, InvalidAuthenticationException {
            return this.ssc.addGroup(group);
        }

        public void updateGroup(SOAPGroup group) throws RemoteException, ApplicationPermissionException, InvalidAuthorizationTokenException, InvalidAuthenticationException, GroupNotFoundException {
            this.ssc.updateGroup(group.getName(), group.getDescription(), group.isActive());
        }

        public void removeGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, InvalidAuthenticationException, GroupNotFoundException {
            this.ssc.removeGroup(groupName);
        }

        public SOAPNestableGroup[] getAllGroupRelationships() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
            return this.ssc.findAllGroupRelationships();
        }
    }
}

