/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.atlassianuser;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.atlassianuser.CrowdUser;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.service.UserManager;
import com.atlassian.crowd.service.cache.CachingManagerFactory;
import com.atlassian.crowd.util.Assert;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.Pagers;
import com.atlassian.user.security.authentication.InvalidPasswordException;
import com.atlassian.user.security.password.Credential;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrowdUserManager
implements com.atlassian.user.UserManager {
    private final RepositoryIdentifier repositoryIdentifier;
    private final UserManager userManager;

    public CrowdUserManager(RepositoryIdentifier repositoryIdentifier) {
        this(repositoryIdentifier, CachingManagerFactory.getUserManagerInstance());
    }

    public CrowdUserManager(RepositoryIdentifier repositoryIdentifier, UserManager userManager) {
        this.userManager = userManager;
        this.repositoryIdentifier = repositoryIdentifier;
    }

    public Pager<User> getUsers() throws EntityException {
        try {
            List userNames = this.userManager.getAllUserNames();
            return new DefaultPager(this.convertStringsToUsers(userNames));
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    protected List<User> convertStringsToUsers(List<String> userNames) {
        if (userNames == null) {
            return new ArrayList<User>(0);
        }
        ArrayList<User> users = new ArrayList<User>(userNames.size());
        for (String name : userNames) {
            users.add((User)new CrowdUser(name, this.userManager));
        }
        return users;
    }

    public Pager<String> getUserNames() throws EntityException {
        try {
            return Pagers.newDefaultPager((Iterable)this.userManager.getAllUserNames());
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public User getUser(String name) throws EntityException {
        try {
            SOAPPrincipal user = this.userManager.getUser(name);
            if (user == null) {
                return null;
            }
            return new CrowdUser(user, this.userManager);
        }
        catch (UserNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public User createUser(String name) throws EntityException {
        Assert.notNull((Object)name);
        SOAPPrincipal principal = new SOAPPrincipal();
        principal.setActive(true);
        principal.setName(name);
        return this.createUser(principal, null);
    }

    public User createUser(User userTemplate, Credential credential) throws EntityException, UnsupportedOperationException, IllegalArgumentException {
        Assert.notNull((Object)userTemplate.getName());
        SOAPPrincipal principal = this.convertUserToSOAPPrincipal(userTemplate);
        PasswordCredential passwordCredential = credential.isEncrypted() ? PasswordCredential.encrypted((String)credential.getValue()) : PasswordCredential.unencrypted((String)credential.getValue());
        return this.createUser(principal, passwordCredential);
    }

    private User createUser(SOAPPrincipal principal, PasswordCredential passwordCredential) throws EntityException {
        try {
            this.userManager.addUser(principal, passwordCredential);
            return new CrowdUser(principal, this.userManager);
        }
        catch (ApplicationPermissionException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public void alterPassword(User user, String password) throws EntityException {
        Assert.notNull((Object)user);
        try {
            this.userManager.updatePassword(user.getName(), new PasswordCredential(password));
        }
        catch (InvalidCredentialException e) {
            throw new InvalidPasswordException(e.getMessage(), (Throwable)e);
        }
        catch (ApplicationPermissionException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public void saveUser(User user) throws EntityException {
        Assert.notNull((Object)user);
        SOAPPrincipal principal = this.convertUserToSOAPPrincipal(user);
        try {
            this.userManager.updateUser(principal);
        }
        catch (ApplicationPermissionException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    private SOAPPrincipal convertUserToSOAPPrincipal(User user) {
        Assert.notNull((Object)user);
        Assert.notNull((Object)user.getName());
        SOAPPrincipal principal = new SOAPPrincipal();
        principal.setActive(true);
        principal.setName(user.getName());
        ArrayList<SOAPAttribute> attributes = new ArrayList<SOAPAttribute>(4);
        attributes.add(new SOAPAttribute("displayName", user.getFullName()));
        attributes.add(new SOAPAttribute("mail", user.getEmail()));
        attributes.add(new SOAPAttribute("givenName", " "));
        attributes.add(new SOAPAttribute("sn", " "));
        principal.setAttributes(attributes.toArray(new SOAPAttribute[attributes.size()]));
        return principal;
    }

    public void removeUser(User user) throws EntityException {
        Assert.notNull((Object)user);
        try {
            this.userManager.removeUser(user.getName());
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public boolean isReadOnly(User user) throws EntityException {
        return false;
    }

    public RepositoryIdentifier getIdentifier() {
        return this.repositoryIdentifier;
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        if (this.getUser(entity.getName()) != null) {
            return this.repositoryIdentifier;
        }
        return null;
    }

    public boolean isCreative() {
        return true;
    }
}

