/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.atlassianuser;

import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.service.UserManager;
import com.atlassian.crowd.service.cache.CachingManagerFactory;
import com.atlassian.crowd.util.Assert;
import com.atlassian.user.impl.DefaultUser;
import org.apache.log4j.Logger;

public class CrowdUser
extends DefaultUser {
    private static final Logger logger = Logger.getLogger(CrowdUser.class);
    private boolean fetchedName;
    private boolean fetchedEmail;
    private SOAPPrincipal principal;
    private final transient UserManager userManager;

    public CrowdUser() {
        this.userManager = CachingManagerFactory.getUserManagerInstance();
    }

    public CrowdUser(String name, UserManager userManager) {
        super(name);
        this.userManager = userManager;
    }

    public CrowdUser(SOAPPrincipal principal, UserManager userManager) {
        Assert.notNull((Object)principal);
        Assert.notNull((Object)principal.getName());
        this.principal = principal;
        this.name = principal.getName();
        this.userManager = userManager;
        this.processEmail();
        this.processFullName();
    }

    public String getFullName() {
        if (!this.fetchedName) {
            this.processFullName();
        }
        return super.getFullName();
    }

    public String getEmail() {
        if (!this.fetchedEmail) {
            this.processEmail();
        }
        return super.getEmail();
    }

    private void processFullName() {
        if (!this.fetchedName) {
            String[] displayName = this.getPropertyValues("displayName");
            if (displayName.length > 0) {
                this.setFullName(displayName[0]);
            } else {
                this.setFullName("");
            }
            this.fetchedName = true;
        }
    }

    protected void processEmail() {
        if (!this.fetchedEmail) {
            String[] email = this.getPropertyValues("mail");
            if (email.length > 0) {
                this.setEmail(email[0]);
            } else {
                this.setEmail("");
            }
            this.fetchedEmail = true;
        }
    }

    protected String[] getPropertyValues(String key) {
        SOAPAttribute[] attributes;
        if (this.principal == null) {
            this.fetchPrincipal();
        }
        if (this.principal != null && (attributes = this.principal.getAttributes()) != null) {
            for (int i = 0; i < attributes.length; ++i) {
                if (!attributes[i].getName().equals(key)) continue;
                return attributes[i].getValues();
            }
        }
        return new String[0];
    }

    protected void fetchPrincipal() {
        try {
            if (this.principal == null) {
                this.principal = this.userManager.getUser(this.name);
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }
}

