package com.atlassian.crowd.user;


import java.util.List;

/**
 * Manually handle username to authorities mapping, rather than depending on the groups they belong to
 */
public interface UserAuthoritiesProvider {
    /**
     * Provides a list of authority names for the given user. eg. ROLE_SYS_ADMIN or ROLE_ADMIN
     *
     * @param username user to request
     * @return list of authority names
     */
    List<String> getAuthorityNames(String username);
}
