/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.crypto;

import com.atlassian.crowd.common.properties.BooleanSystemProperty;
import com.atlassian.crowd.common.properties.EncryptionProperties;
import com.atlassian.crowd.crypto.Algorithm;
import com.atlassian.crowd.crypto.CachedEncryptor;
import com.atlassian.crowd.crypto.DbConfigPasswordCipherEncryptor;
import com.atlassian.crowd.crypto.MissingKeyHandlingEncryptor;
import com.atlassian.crowd.crypto.SaltingEncryptor;
import com.atlassian.crowd.embedded.api.Encryptor;
import com.atlassian.crowd.manager.property.EncryptionSettings;
import com.atlassian.db.config.password.CipherProvider;
import com.atlassian.db.config.password.DefaultCipherProvider;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DbConfigPasswordCipherEncryptorsFactory {
    private DbConfigPasswordCipherEncryptorsFactory() {
    }

    public static Map<String, Encryptor> createEncryptorsMap(EncryptionSettings encryptionSettings) {
        DefaultCipherProvider cipherProvider = new DefaultCipherProvider();
        HashMap<String, Encryptor> encryptors = new HashMap<String, Encryptor>();
        encryptors.put(Algorithm.AES.getKey(), DbConfigPasswordCipherEncryptorsFactory.createDbConfigPasswordCipherEncryptor("AES/CBC/PKCS5Padding", "AES", encryptionSettings, cipherProvider));
        encryptors.put(Algorithm.DES.getKey(), DbConfigPasswordCipherEncryptorsFactory.createDbConfigPasswordCipherEncryptor("DES/CBC/PKCS5Padding", "DES", encryptionSettings, cipherProvider));
        encryptors.put(Algorithm.DESEDE.getKey(), DbConfigPasswordCipherEncryptorsFactory.createDbConfigPasswordCipherEncryptor("DESede/CBC/PKCS5Padding", "DESede", encryptionSettings, cipherProvider));
        return Collections.unmodifiableMap(encryptors);
    }

    private static Encryptor createDbConfigPasswordCipherEncryptor(String algorithm, String algorithmKey, EncryptionSettings encryptionSettings, DefaultCipherProvider cipherProvider) {
        DbConfigPasswordCipherEncryptor encryptor = new DbConfigPasswordCipherEncryptor(algorithm, algorithmKey, encryptionSettings, (CipherProvider)cipherProvider);
        return new MissingKeyHandlingEncryptor((Encryptor)new SaltingEncryptor((Encryptor)new CachedEncryptor((Encryptor)encryptor, (long)((Integer)EncryptionProperties.ENCRYPTION_CACHE_MAX_SIZE.getValue()).intValue(), (Duration)EncryptionProperties.ENCRYPTION_CACHE_EXPIRATION.getValue(), () -> ((BooleanSystemProperty)EncryptionProperties.ENRCYPTION_CACHE_ENABLED).getValue())));
    }
}

